/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSResourceLimitException;
import io.sf.carte.doc.style.css.CSSSupportsRule;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.DeclarationCondition;
import io.sf.carte.doc.style.css.nsac.SelectorFunction;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.DOMException;

public class SupportsRule
extends GroupingRule
implements CSSSupportsRule {
    private static final long serialVersionUID = 1L;
    private BooleanCondition condition = null;

    protected SupportsRule(AbstractCSSStyleSheet abstractCSSStyleSheet, byte by) {
        super(abstractCSSStyleSheet, (short)12, by);
    }

    SupportsRule(AbstractCSSStyleSheet abstractCSSStyleSheet, SupportsRule supportsRule) {
        super(abstractCSSStyleSheet, supportsRule);
        this.condition = supportsRule.getCondition();
    }

    protected SupportsRule(AbstractCSSStyleSheet abstractCSSStyleSheet, BooleanCondition booleanCondition, byte by) {
        super(abstractCSSStyleSheet, (short)12, by);
        if (booleanCondition == null) {
            throw new NullPointerException("Null @supports condition.");
        }
        this.condition = booleanCondition;
    }

    @Override
    public String getConditionText() {
        return this.condition != null ? this.condition.toString() : "";
    }

    @Override
    public void setConditionText(String string) throws DOMException {
        this.parseConditionText(string);
    }

    private void parseConditionText(String string) throws DOMException {
        CSSParser cSSParser = (CSSParser)this.createSACParser();
        try {
            this.condition = cSSParser.parseSupportsCondition(string, null, this.getParentStyleSheet());
        }
        catch (CSSBudgetException cSSBudgetException) {
            throw new CSSResourceLimitException("Limit found while parsing condition " + string, cSSBudgetException);
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(12, "Error parsing condition: " + string);
            dOMException.initCause(cSSException);
            throw dOMException;
        }
    }

    @Override
    public BooleanCondition getCondition() {
        return this.condition;
    }

    @Override
    public boolean supports(StyleDatabase styleDatabase) {
        return this.condition != null && this.supports(this.condition, styleDatabase);
    }

    private boolean supports(BooleanCondition booleanCondition, StyleDatabase styleDatabase) {
        switch (booleanCondition.getType()) {
            case PREDICATE: {
                DeclarationCondition declarationCondition = (DeclarationCondition)booleanCondition;
                return styleDatabase.supports(declarationCondition.getName(), declarationCondition.getValue());
            }
            case AND: {
                List<BooleanCondition> list = booleanCondition.getSubConditions();
                if (list == null) {
                    AbstractCSSStyleSheet abstractCSSStyleSheet = this.getParentStyleSheet();
                    if (abstractCSSStyleSheet != null) {
                        abstractCSSStyleSheet.getErrorHandler().conditionalRuleError(this.condition, "No conditions inside and(): " + this.condition.toString());
                    }
                    return false;
                }
                Iterator<BooleanCondition> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (this.supports(iterator.next(), styleDatabase)) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                BooleanCondition booleanCondition2 = booleanCondition.getNestedCondition();
                if (booleanCondition2 == null) {
                    AbstractCSSStyleSheet abstractCSSStyleSheet = this.getParentStyleSheet();
                    if (abstractCSSStyleSheet != null) {
                        abstractCSSStyleSheet.getErrorHandler().conditionalRuleError(this.condition, "No conditions inside not(): " + this.condition.toString());
                    }
                    return false;
                }
                return !this.supports(booleanCondition2, styleDatabase);
            }
            case OR: {
                List<BooleanCondition> list = booleanCondition.getSubConditions();
                if (list == null) {
                    AbstractCSSStyleSheet abstractCSSStyleSheet = this.getParentStyleSheet();
                    if (abstractCSSStyleSheet != null) {
                        abstractCSSStyleSheet.getErrorHandler().conditionalRuleError(this.condition, "No conditions inside or(): " + this.condition.toString());
                    }
                    return false;
                }
                Iterator<BooleanCondition> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!this.supports(iterator.next(), styleDatabase)) continue;
                    return true;
                }
                break;
            }
            case SELECTOR_FUNCTION: {
                SelectorFunction selectorFunction = (SelectorFunction)booleanCondition;
                return styleDatabase.supports(selectorFunction.getSelectors());
            }
        }
        return false;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(50 + this.getCssRules().getLength() * 32);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.condition != null || !this.getCssRules().isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(30 + this.getCssRules().getLength() * 20);
            stringBuilder.append("@supports");
            if (this.condition != null) {
                this.condition.appendMinifiedText(stringBuilder);
            }
            stringBuilder.append('{');
            Iterator iterator = this.getCssRules().iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(((AbstractCSSRule)iterator.next()).getMinifiedCssText());
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        if (this.condition != null || !this.getCssRules().isEmpty()) {
            styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
            simpleWriter.write((CharSequence)"@supports ");
            simpleWriter.write((CharSequence)this.getConditionText());
            styleFormattingContext.updateContext(this);
            styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
            this.getCssRules().writeCssText(simpleWriter, styleFormattingContext);
            styleFormattingContext.endCurrentContext(this);
            styleFormattingContext.endRuleList(simpleWriter);
            styleFormattingContext.writeRightCurlyBracket(simpleWriter);
            styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
        }
    }

    @Override
    protected void setGroupingRule(GroupingRule groupingRule) throws DOMException {
        SupportsRule supportsRule = (SupportsRule)groupingRule;
        this.condition = supportsRule.condition;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.condition == null ? 0 : this.condition.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SupportsRule supportsRule = (SupportsRule)object;
        return !(this.condition == null ? supportsRule.condition != null : !this.condition.equals(supportsRule.condition));
    }

    @Override
    public SupportsRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        return new SupportsRule(abstractCSSStyleSheet, this);
    }
}

