/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class ViewportRule
extends BaseCSSDeclarationRule {
    private static final long serialVersionUID = 1L;

    public ViewportRule(AbstractCSSStyleSheet abstractCSSStyleSheet, byte by) {
        super(abstractCSSStyleSheet, (short)15, by);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        return "@viewport{" + this.getStyle().getMinifiedCssText() + '}';
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
        simpleWriter.write((CharSequence)"@viewport");
        styleFormattingContext.updateContext(this);
        styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
        styleFormattingContext.startStyleDeclaration(simpleWriter);
        this.getStyle().writeCssText(simpleWriter, styleFormattingContext);
        styleFormattingContext.endCurrentContext(this);
        styleFormattingContext.endStyleDeclaration(simpleWriter);
        styleFormattingContext.writeRightCurlyBracket(simpleWriter);
        styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
    }

    @Override
    public void setCssText(String string) throws DOMException {
        string = string.trim();
        int n = string.length();
        int n2 = string.indexOf(123);
        if (n < 15 || n2 == -1) {
            throw new DOMException(12, "Invalid @viewport rule: " + string);
        }
        String string2 = string.substring(9, n2).trim();
        if (string2.length() != 0) {
            throw new DOMException(12, "Invalid @viewport rule: " + string);
        }
        super.setCssText(string);
    }

    @Override
    void startAtRule(String string, String string2) {
        if (!"viewport".equalsIgnoreCase(string)) {
            throw new DOMException(13, "Cannot set rule of type: " + string);
        }
    }

    @Override
    public ViewportRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        ViewportRule viewportRule = new ViewportRule(abstractCSSStyleSheet, this.getOrigin());
        String string = this.getParentStyleSheet().getHref();
        viewportRule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), string);
        return viewportRule;
    }
}

