/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.MarkerBridge;
import io.sf.carte.echosvg.bridge.PaintBridge;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.css.engine.value.ColorFunction;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.RGBColorValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.ext.awt.color.ColorContext;
import io.sf.carte.echosvg.ext.awt.color.StandardColorSpaces;
import io.sf.carte.echosvg.gvt.CompositeShapePainter;
import io.sf.carte.echosvg.gvt.FillShapePainter;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.Marker;
import io.sf.carte.echosvg.gvt.MarkerShapePainter;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.gvt.ShapePainter;
import io.sf.carte.echosvg.gvt.StrokeShapePainter;
import io.sf.carte.echosvg.util.CSSConstants;
import io.sf.carte.echosvg.util.SVGConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import org.w3c.css.om.typed.CSSStyleValueList;
import org.w3c.dom.Element;

public abstract class PaintServer
implements SVGConstants,
CSSConstants,
ErrorConstants {
    protected PaintServer() {
    }

    public static ShapePainter convertMarkers(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 40);
        Marker marker = PaintServer.convertMarker(element, value, bridgeContext);
        value = CSSUtilities.getComputedStyle(element, 39);
        Marker marker2 = PaintServer.convertMarker(element, value, bridgeContext);
        value = CSSUtilities.getComputedStyle(element, 38);
        Marker marker3 = PaintServer.convertMarker(element, value, bridgeContext);
        if (marker != null || marker2 != null || marker3 != null) {
            MarkerShapePainter markerShapePainter = new MarkerShapePainter(shapeNode.getShape());
            markerShapePainter.setStartMarker(marker);
            markerShapePainter.setMiddleMarker(marker2);
            markerShapePainter.setEndMarker(marker3);
            return markerShapePainter;
        }
        return null;
    }

    public static Marker convertMarker(Element element, Value value, BridgeContext bridgeContext) {
        if (value.getPrimitiveType() == CSSValue.Type.IDENT) {
            return null;
        }
        String string = value.getURIValue();
        Element element2 = bridgeContext.getReferencedElement(element, string);
        if (element2 == null) {
            return null;
        }
        Bridge bridge = bridgeContext.getBridge(element2);
        if (bridge == null) {
            return null;
        }
        if (!(bridge instanceof MarkerBridge)) {
            BridgeException bridgeException = new BridgeException(bridgeContext, element, "css.uri.badTarget", new Object[]{string});
            UserAgent userAgent = bridgeContext.getUserAgent();
            if (userAgent == null) {
                throw bridgeException;
            }
            userAgent.displayError(bridgeException);
            return null;
        }
        return ((MarkerBridge)bridge).createMarker(bridgeContext, element2, element);
    }

    public static ShapePainter convertFillAndStroke(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Shape shape = shapeNode.getShape();
        if (shape == null) {
            return null;
        }
        Paint paint = PaintServer.convertFillPaint(element, (GraphicsNode)shapeNode, bridgeContext);
        FillShapePainter fillShapePainter = new FillShapePainter(shape, (ColorContext)bridgeContext);
        fillShapePainter.setPaint(paint);
        Stroke stroke = PaintServer.convertStroke(element);
        if (stroke == null) {
            return fillShapePainter;
        }
        Paint paint2 = PaintServer.convertStrokePaint(element, (GraphicsNode)shapeNode, bridgeContext);
        StrokeShapePainter strokeShapePainter = new StrokeShapePainter(shape, (ColorContext)bridgeContext);
        strokeShapePainter.setStroke(stroke);
        strokeShapePainter.setPaint(paint2);
        CompositeShapePainter compositeShapePainter = new CompositeShapePainter(shape);
        compositeShapePainter.addShapePainter((ShapePainter)fillShapePainter);
        compositeShapePainter.addShapePainter((ShapePainter)strokeShapePainter);
        return compositeShapePainter;
    }

    public static ShapePainter convertStrokePainter(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Shape shape = shapeNode.getShape();
        if (shape == null) {
            return null;
        }
        Stroke stroke = PaintServer.convertStroke(element);
        if (stroke == null) {
            return null;
        }
        Paint paint = PaintServer.convertStrokePaint(element, (GraphicsNode)shapeNode, bridgeContext);
        StrokeShapePainter strokeShapePainter = new StrokeShapePainter(shape, (ColorContext)bridgeContext);
        strokeShapePainter.setStroke(stroke);
        strokeShapePainter.setPaint(paint);
        return strokeShapePainter;
    }

    public static Paint convertStrokePaint(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 55);
        float f = PaintServer.convertOpacity(value);
        value = CSSUtilities.getComputedStyle(element, 49);
        return PaintServer.convertPaint(element, graphicsNode, value, f, bridgeContext);
    }

    public static Paint convertFillPaint(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 15);
        float f = PaintServer.convertOpacity(value);
        value = CSSUtilities.getComputedStyle(element, 14);
        return PaintServer.convertPaint(element, graphicsNode, value, f, bridgeContext);
    }

    public static Paint convertPaint(Element element, GraphicsNode graphicsNode, Value value, float f, BridgeContext bridgeContext) {
        if (value.getCssValueType() == CSSValue.CssType.TYPED) {
            switch (value.getPrimitiveType()) {
                case IDENT: {
                    return null;
                }
                case COLOR: {
                    return PaintServer.convertColor(value.getColorValue(), f, bridgeContext);
                }
                case URI: {
                    return PaintServer.convertURIPaint(element, graphicsNode, value, f, bridgeContext);
                }
            }
        } else {
            Value value2 = value.item(0);
            switch (value2.getPrimitiveType()) {
                case URI: {
                    Paint paint = PaintServer.silentConvertURIPaint(element, graphicsNode, value2, f, bridgeContext);
                    if (paint != null) {
                        return paint;
                    }
                    value2 = value.item(1);
                    switch (value2.getPrimitiveType()) {
                        case IDENT: {
                            return null;
                        }
                        case COLOR: {
                            ColorValue colorValue = value2.getColorValue();
                            return PaintServer.convertColor(colorValue, f, bridgeContext);
                        }
                    }
                }
            }
        }
        throw new IllegalArgumentException("Paint argument is not an appropriate CSS value (" + value.getCssText() + ").");
    }

    public static Paint silentConvertURIPaint(Element element, GraphicsNode graphicsNode, Value value, float f, BridgeContext bridgeContext) {
        Paint paint = null;
        try {
            paint = PaintServer.convertURIPaint(element, graphicsNode, value, f, bridgeContext);
        }
        catch (BridgeException bridgeException) {
            // empty catch block
        }
        return paint;
    }

    public static Paint convertURIPaint(Element element, GraphicsNode graphicsNode, Value value, float f, BridgeContext bridgeContext) {
        String string = value.getURIValue();
        Element element2 = bridgeContext.getReferencedElement(element, string);
        if (element2 == null) {
            return null;
        }
        Bridge bridge = bridgeContext.getBridge(element2);
        if (bridge == null) {
            return null;
        }
        if (!(bridge instanceof PaintBridge)) {
            BridgeException bridgeException = new BridgeException(bridgeContext, element, "css.uri.badTarget", new Object[]{string});
            UserAgent userAgent = bridgeContext.getUserAgent();
            if (userAgent == null) {
                throw bridgeException;
            }
            userAgent.displayError(bridgeException);
            return null;
        }
        return ((PaintBridge)bridge).createPaint(bridgeContext, element2, element, graphicsNode, f);
    }

    public static Color convertColor(ColorValue colorValue, float f, BridgeContext bridgeContext) {
        switch (colorValue.getCSSColorSpace()) {
            case "rgb": {
                return PaintServer.convertColor((RGBColorValue)colorValue, f);
            }
            case "lab": 
            case "lch": {
                throw new UnsupportedOperationException();
            }
        }
        return PaintServer.convertColor((ColorFunction)colorValue, f, bridgeContext);
    }

    public static Color convertColor(RGBColorValue rGBColorValue, float f) {
        float f2 = PaintServer.resolveColorComponent(rGBColorValue.getR());
        float f3 = PaintServer.resolveColorComponent(rGBColorValue.getG());
        float f4 = PaintServer.resolveColorComponent(rGBColorValue.getB());
        float f5 = PaintServer.resolveAlphaComponent((Value)rGBColorValue.getAlpha());
        return new Color(f2, f3, f4, f5 * f);
    }

    public static Color convertColor(ColorFunction colorFunction, float f, BridgeContext bridgeContext) {
        switch (colorFunction.getCSSColorSpace()) {
            case "display-p3": {
                ICC_ColorSpace iCC_ColorSpace = StandardColorSpaces.getDisplayP3();
                Color color = PaintServer.convert3Color(iCC_ColorSpace, colorFunction, f);
                bridgeContext.updateColorSpace(color, iCC_ColorSpace);
                return color;
            }
            case "a98-rgb": {
                ICC_ColorSpace iCC_ColorSpace = StandardColorSpaces.getA98RGB();
                Color color = PaintServer.convert3Color(iCC_ColorSpace, colorFunction, f);
                bridgeContext.updateColorSpace(color, iCC_ColorSpace);
                return color;
            }
            case "prophoto-rgb": {
                ICC_ColorSpace iCC_ColorSpace = StandardColorSpaces.getProphotoRGB();
                Color color = PaintServer.convert3Color(iCC_ColorSpace, colorFunction, f);
                bridgeContext.updateColorSpace(color, iCC_ColorSpace);
                return color;
            }
            case "rec2020": {
                ICC_ColorSpace iCC_ColorSpace = StandardColorSpaces.getRec2020();
                Color color = PaintServer.convert3Color(iCC_ColorSpace, colorFunction, f);
                bridgeContext.updateColorSpace(color, iCC_ColorSpace);
                return color;
            }
            case "srgb-linear": {
                ColorSpace colorSpace = ColorSpace.getInstance(1004);
                return PaintServer.convert3Color(colorSpace, colorFunction, f);
            }
            case "xyz": 
            case "xyz-d65": {
                CSSStyleValueList cSSStyleValueList = colorFunction.getChannels();
                float[] fArray = new float[]{PaintServer.resolveColorComponent((NumericValue)cSSStyleValueList.item(0)), PaintServer.resolveColorComponent((NumericValue)cSSStyleValueList.item(1)), PaintServer.resolveColorComponent((NumericValue)cSSStyleValueList.item(2))};
                float[] fArray2 = PaintServer.d65xyzToD50(fArray);
                float f2 = PaintServer.resolveAlphaComponent((Value)colorFunction.getAlpha());
                ColorSpace colorSpace = ColorSpace.getInstance(1001);
                Color color = new Color(colorSpace, fArray2, f2 * f);
                colorSpace = StandardColorSpaces.containerRGBSpace((Color)color, (ColorSpace)bridgeContext.getColorSpace());
                if (colorSpace != null) {
                    bridgeContext.updateColorSpace(color, colorSpace);
                }
                return color;
            }
            case "xyz-d50": {
                ColorSpace colorSpace = ColorSpace.getInstance(1001);
                Color color = PaintServer.convert3Color(colorSpace, colorFunction, f);
                colorSpace = StandardColorSpaces.containerRGBSpace((Color)color, (ColorSpace)bridgeContext.getColorSpace());
                if (colorSpace != null) {
                    bridgeContext.updateColorSpace(color, colorSpace);
                }
                return color;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Color convert3Color(ColorSpace colorSpace, ColorFunction colorFunction, float f) {
        CSSStyleValueList cSSStyleValueList = colorFunction.getChannels();
        float[] fArray = new float[]{PaintServer.resolveColorComponent((NumericValue)cSSStyleValueList.item(0)), PaintServer.resolveColorComponent((NumericValue)cSSStyleValueList.item(1)), PaintServer.resolveColorComponent((NumericValue)cSSStyleValueList.item(2))};
        float f2 = PaintServer.resolveAlphaComponent((Value)colorFunction.getAlpha());
        return new Color(colorSpace, fArray, f2 * f);
    }

    private static float resolveColorComponent(NumericValue numericValue) {
        switch (numericValue.getUnitType()) {
            case 0: {
                float f = numericValue.getFloatValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                return f;
            }
            case 2: {
                float f = numericValue.getFloatValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 100.0f) {
                    f = 100.0f;
                }
                return f / 100.0f;
            }
        }
        throw new IllegalArgumentException("Invalid color component: " + numericValue.getCssText());
    }

    private static float[] d65xyzToD50(float[] fArray) {
        float[] fArray2 = new float[]{(float)(1.0478112436606313 * (double)fArray[0] + 0.022886602481693052 * (double)fArray[1] - 0.05012697596852886 * (double)fArray[2]), (float)(0.029542398290574905 * (double)fArray[0] + 0.9904844034904394 * (double)fArray[1] - 0.017049095628961564 * (double)fArray[2]), (float)(-0.009234489723309473 * (double)fArray[0] + 0.015043616793498756 * (double)fArray[1] + 0.7521316354746059 * (double)fArray[2])};
        return fArray2;
    }

    public static Stroke convertStroke(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 56);
        float f = value.getFloatValue();
        if (f == 0.0f) {
            return null;
        }
        value = CSSUtilities.getComputedStyle(element, 52);
        int n = PaintServer.convertStrokeLinecap(value);
        value = CSSUtilities.getComputedStyle(element, 53);
        int n2 = PaintServer.convertStrokeLinejoin(value);
        value = CSSUtilities.getComputedStyle(element, 54);
        float f2 = PaintServer.convertStrokeMiterlimit(value);
        value = CSSUtilities.getComputedStyle(element, 50);
        float[] fArray = PaintServer.convertStrokeDasharray(value);
        float f3 = 0.0f;
        if (fArray != null && (f3 = (value = CSSUtilities.getComputedStyle(element, 51)).getFloatValue()) < 0.0f) {
            float f4 = 0.0f;
            for (float f5 : fArray) {
                f4 += f5;
            }
            if (fArray.length % 2 != 0) {
                f4 *= 2.0f;
            }
            if (f4 == 0.0f) {
                f3 = 0.0f;
            } else {
                while (f3 < 0.0f) {
                    f3 += f4;
                }
            }
        }
        return new BasicStroke(f, n, n2, f2, fArray, f3);
    }

    public static float[] convertStrokeDasharray(Value value) {
        float[] fArray = null;
        if (value.getCssValueType() == CSSValue.CssType.LIST) {
            int n = value.getLength();
            fArray = new float[n];
            float f = 0.0f;
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = value.item(i).getFloatValue();
                f += fArray[i];
            }
            if (f == 0.0f) {
                fArray = null;
            }
        }
        return fArray;
    }

    public static float convertStrokeMiterlimit(Value value) {
        float f = value.getFloatValue();
        return f < 1.0f ? 1.0f : f;
    }

    public static int convertStrokeLinecap(Value value) {
        String string = value.getIdentifierValue();
        switch (string.charAt(0)) {
            case 'b': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 's': {
                return 2;
            }
        }
        throw new IllegalArgumentException("Linecap argument is not an appropriate CSS value");
    }

    public static int convertStrokeLinejoin(Value value) {
        String string = value.getIdentifierValue();
        switch (string.charAt(0)) {
            case 'm': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 'b': {
                return 2;
            }
        }
        throw new IllegalArgumentException("Linejoin argument is not an appropriate CSS value");
    }

    private static float resolveAlphaComponent(Value value) {
        switch (value.getUnitType()) {
            case 2: {
                float f = value.getFloatValue();
                f = f > 100.0f ? 100.0f : (f < 0.0f ? 0.0f : f);
                return f * 0.01f;
            }
            case 0: {
                float f = value.getFloatValue();
                f = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
                return f;
            }
        }
        throw new IllegalArgumentException("Color alpha argument is not an appropriate CSS value");
    }

    public static float convertOpacity(Value value) {
        float f = value.getFloatValue();
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }
}

