/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.permission;

import java.util.HashMap;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.permission.ScopePolicyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.authorization.ScopePermissionRepresentation;

public class ScopePolicyProviderFactory
implements PolicyProviderFactory<ScopePermissionRepresentation> {
    public static final String ID = "scope";
    private final ScopePolicyProvider provider = new ScopePolicyProvider();

    public String getName() {
        return "Scope-Based";
    }

    public String getGroup() {
        return "Permission";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return this.provider;
    }

    public Class<ScopePermissionRepresentation> getRepresentationType() {
        return ScopePermissionRepresentation.class;
    }

    public ScopePermissionRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        ScopePermissionRepresentation representation = new ScopePermissionRepresentation();
        representation.setResourceType((String)policy.getConfig().get("defaultResourceType"));
        return representation;
    }

    public void onCreate(Policy policy, ScopePermissionRepresentation representation, AuthorizationProvider authorization) {
        this.updateResourceType(policy, representation);
    }

    public void onUpdate(Policy policy, ScopePermissionRepresentation representation, AuthorizationProvider authorization) {
        this.updateResourceType(policy, representation);
    }

    public void onRemove(Policy policy, AuthorizationProvider authorization) {
        AdminPermissionsSchema.SCHEMA.removeOrphanResources(policy, authorization);
    }

    private void updateResourceType(Policy policy, ScopePermissionRepresentation representation) {
        if (representation != null) {
            HashMap<String, String> config = new HashMap<String, String>(policy.getConfig());
            config.compute("defaultResourceType", (key, value) -> {
                String resourceType = representation.getResourceType();
                return resourceType != null ? representation.getResourceType() : null;
            });
            policy.setConfig(config);
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

