/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.TimestampaddFunction;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class IntegralTimestampaddFunction
extends TimestampaddFunction {
    private final Dialect dialect;
    private final CastFunction castFunction;
    private final BasicType<Integer> integerType;

    public IntegralTimestampaddFunction(Dialect dialect, TypeConfiguration typeConfiguration) {
        super(dialect, typeConfiguration);
        this.dialect = dialect;
        this.integerType = typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
        this.castFunction = new CastFunction(dialect, dialect.getPreferredSqlTypeCodeForBoolean());
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        DurationUnit field = (DurationUnit)arguments.get(0);
        Expression magnitude = (Expression)arguments.get(1);
        Expression to = (Expression)arguments.get(2);
        TemporalUnit unit = this.bestTemporalUnit(magnitude, field);
        if (unit != field.getUnit()) {
            this.renderWithUnitConversion(sqlAppender, magnitude, to, walker, field, unit);
        } else {
            super.render(sqlAppender, arguments, returnType, walker);
        }
    }

    private void renderWithUnitConversion(SqlAppender sqlAppender, Expression magnitude, Expression to, SqlAstTranslator<?> walker, DurationUnit field, TemporalUnit unit) {
        this.patternRenderer(unit, magnitude, to).render(sqlAppender, this.convertedArguments(field, unit, magnitude, to), walker);
    }

    private List<SqlAstNode> convertedArguments(DurationUnit field, TemporalUnit unit, Expression magnitude, Expression to) {
        return Arrays.asList(new DurationUnit(unit, field.getExpressionType()), new SelfRenderingFunctionSqlAstExpression<Integer>("cast", this.castFunction, Arrays.asList(this.convertedArgument(field, unit, magnitude), new CastTarget(this.integerType)), this.integerType, this.integerType), to);
    }

    private Expression convertedArgument(DurationUnit field, TemporalUnit unit, Expression magnitude) {
        BasicValuedMapping expressionType = (BasicValuedMapping)magnitude.getExpressionType();
        String conversionFactor = field.getUnit().conversionFactorFull(unit, this.dialect);
        return conversionFactor.isEmpty() ? magnitude : new BinaryArithmeticExpression(magnitude, conversionFactor.charAt(0) == '*' ? BinaryArithmeticOperator.MULTIPLY : BinaryArithmeticOperator.DIVIDE, new QueryLiteral(expressionType.getExpressibleJavaType().fromString(conversionFactor.substring(1)), expressionType), expressionType);
    }

    private TemporalUnit bestTemporalUnit(Expression magnitude, DurationUnit field) {
        JdbcType jdbcType = magnitude.getExpressionType().getSingleJdbcMapping().getJdbcType();
        if (jdbcType.isFloat()) {
            return field.getUnit() == TemporalUnit.SECOND ? TemporalUnit.NATIVE : TemporalUnit.SECOND;
        }
        return field.getUnit();
    }
}

