/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import java.util.List;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.statetransfer.BaseXSiteStateProviderState;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;

public class AsyncProviderState
extends BaseXSiteStateProviderState<AsyncOutboundTask> {
    private static final Log log = LogFactory.getLog(AsyncProviderState.class);

    private AsyncProviderState(XSiteBackup backup, XSiteStateTransferConfiguration configuration) {
        super(backup, configuration);
    }

    public static AsyncProviderState create(BackupConfiguration config) {
        XSiteBackup backup = new XSiteBackup(config.site(), true, config.stateTransfer().timeout());
        return new AsyncProviderState(backup, config.stateTransfer());
    }

    @Override
    public boolean isSync() {
        return false;
    }

    @Override
    AsyncOutboundTask createTask(Address originator, XSiteStateProvider provider) {
        return new AsyncOutboundTask(originator, provider, this);
    }

    static class AsyncOutboundTask
    extends BaseXSiteStateProviderState.OutboundTask {
        AsyncOutboundTask(Address coordinator, XSiteStateProvider provider, AsyncProviderState state) {
            super(coordinator, provider, state);
        }

        public CompletableSource apply(List<XSiteState> xSiteStates) {
            if (log.isDebugEnabled()) {
                log.debugf("Sending chunk to site '%s'. Chunk has %s keys.", this.state.getBackup().getSiteName(), xSiteStates.size());
            }
            return Completable.fromCompletionStage(this.provider.getIracManager().trackForStateTransfer(xSiteStates));
        }
    }
}

