/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Desktop;
import java.awt.Taskbar;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitResponse;
import java.io.IOException;
import javax.swing.Box;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.gui.actions.ShowAboutAction;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.mac.OsxIndicatorThread;
import mediathek.mac.OsxPowerManager;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.MacNotificationCenter;
import mediathek.tool.threads.IndicatorThread;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0015J\b\u0010\u0011\u001a\u00020\nH\u0014J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0014J\b\u0010\u0014\u001a\u00020\nH\u0014J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\nH\u0014J\b\u0010\u0019\u001a\u00020\nH\u0002J\b\u0010\u001a\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lmediathek/mac/MediathekGuiMac;", "Lmediathek/mainwindow/MediathekGui;", "()V", "powerManager", "Lmediathek/mac/OsxPowerManager;", "createProgressIndicatorThread", "Lmediathek/tool/threads/IndicatorThread;", "getNotificationCenter", "Lmediathek/tool/notification/INotificationCenter;", "handleDownloadFinishedEvent", "", "msg", "Lmediathek/gui/messages/DownloadFinishedEvent;", "handleDownloadStart", "Lmediathek/gui/messages/DownloadStartEvent;", "handleInstallTabSwitchListenerEvent", "Lmediathek/gui/messages/InstallTabSwitchListenerEvent;", "initMenus", "initializeSystemTray", "installAdditionalHelpEntries", "installMenuTabSwitchListener", "setDownloadsBadge", "numDownloads", "", "setupScrollBarWidth", "setupUserInterfaceForOsx", "shutdownComputer", "Companion", "MediathekView"})
public final class MediathekGuiMac
extends MediathekGui {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OsxPowerManager powerManager = new OsxPowerManager();
    @NotNull
    private static final Logger logger;

    @Override
    protected void installAdditionalHelpEntries() {
    }

    @Override
    protected void setupScrollBarWidth() {
    }

    @Override
    public void initializeSystemTray() {
    }

    @Override
    @NotNull
    protected INotificationCenter getNotificationCenter() {
        return new MacNotificationCenter();
    }

    @Override
    protected void shutdownComputer() {
        try {
            Runtime.getRuntime().exec("nohup bin/mv_shutdown_helper");
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    @Override
    protected void installMenuTabSwitchListener() {
    }

    @Override
    @Handler
    protected void handleInstallTabSwitchListenerEvent(@NotNull InstallTabSwitchListenerEvent msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
    }

    @Override
    protected void initMenus() {
        super.initMenus();
        this.setupUserInterfaceForOsx();
    }

    @Override
    @NotNull
    protected IndicatorThread createProgressIndicatorThread() {
        return new OsxIndicatorThread();
    }

    @Override
    protected void handleDownloadStart(@NotNull DownloadStartEvent msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        super.handleDownloadStart(msg);
        this.powerManager.disablePowerManagement();
        this.setDownloadsBadge(this.numDownloadsStarted.get());
    }

    @Override
    protected void handleDownloadFinishedEvent(@NotNull DownloadFinishedEvent msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        super.handleDownloadFinishedEvent(msg);
        int numDownloads = this.numDownloadsStarted.get();
        if (numDownloads == 0) {
            this.powerManager.enablePowerManagement();
        }
        this.setDownloadsBadge(numDownloads);
    }

    private final void setDownloadsBadge(int numDownloads) {
        Taskbar taskbar;
        if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_BADGE_NUMBER)) {
            if (numDownloads > 0) {
                taskbar.setIconBadge(String.valueOf(numDownloads));
            } else {
                taskbar.setIconBadge("");
            }
        }
    }

    private final void setupUserInterfaceForOsx() {
        Desktop desktop = Desktop.getDesktop();
        desktop.disableSuddenTermination();
        if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            desktop.setQuitHandler((arg_0, arg_1) -> MediathekGuiMac.setupUserInterfaceForOsx$lambda$0(this, arg_0, arg_1));
        }
        if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
            desktop.setAboutHandler(MediathekGuiMac::setupUserInterfaceForOsx$lambda$1);
        }
        if (desktop.isSupported(Desktop.Action.APP_PREFERENCES)) {
            desktop.setPreferencesHandler(arg_0 -> MediathekGuiMac.setupUserInterfaceForOsx$lambda$2(this, arg_0));
        }
        this.getRootPane().putClientProperty("apple.awt.windowTitleVisible", false);
        if (SystemInfo.isMacFullWindowContentSupported) {
            this.getRootPane().putClientProperty("apple.awt.fullWindowContent", true);
            this.getRootPane().putClientProperty("apple.awt.transparentTitleBar", true);
            this.commonToolBar.add(Box.createHorizontalStrut(70), 0);
        }
    }

    private static final void setupUserInterfaceForOsx$lambda$0(MediathekGuiMac this$0, QuitEvent quitEvent, QuitResponse response) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(response, "response");
        if (!this$0.quitApplication()) {
            response.cancelQuit();
        } else {
            response.performQuit();
        }
    }

    private static final void setupUserInterfaceForOsx$lambda$1(AboutEvent it) {
        new ShowAboutAction().actionPerformed(null);
    }

    private static final void setupUserInterfaceForOsx$lambda$2(MediathekGuiMac this$0, PreferencesEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.getSettingsDialog().setVisible(true);
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger()");
        MediathekGuiMac.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lmediathek/mac/MediathekGuiMac$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

