/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.starter;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.controller.starter.HttpDownloadState;
import mediathek.controller.starter.RuntimeExec;
import mediathek.controller.starter.Start;
import mediathek.controller.starter.StarterClass;
import mediathek.daten.DatenDownload;
import mediathek.gui.dialog.DialogContinueDownload;
import mediathek.gui.dialog.MeldungDownloadfehler;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.MVInfoFile;
import mediathek.tool.MVSubtitle;
import mediathek.tool.MessageBus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalProgramDownload
extends Thread {
    private static final Logger logger = LogManager.getLogger();
    private static final int STAT_START = 0;
    private static final int STAT_LAUFEN = 1;
    private static final int STAT_RESTART = 3;
    private static final int STAT_PRUEFEN = 4;
    private static final int STAT_FERTIG_OK = 10;
    private static final int STAT_FERTIG_FEHLER = 11;
    private static final int STAT_ENDE = 99;
    private final DatenDownload datenDownload;
    private final Start start;
    private File file;
    private boolean retAbbrechen;
    private boolean dialogAbbrechenIsVis;
    private HttpDownloadState state = HttpDownloadState.DOWNLOAD;
    private CompletableFuture<Void> infoFuture;
    private CompletableFuture<Void> subtitleFuture;

    public ExternalProgramDownload(DatenDownload d) {
        this.setName("EXTERNAL PROGRAM DL THREAD: " + d.arr[5]);
        this.datenDownload = d;
        this.start = this.datenDownload.start;
        this.start.status = (byte)2;
        this.file = new File(this.datenDownload.arr[31]);
        StarterClass.notifyStartEvent(this.datenDownload);
        try {
            Files.createDirectories(Paths.get(this.datenDownload.arr[30], new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Failed to create directories", (Throwable)e);
        }
    }

    @Override
    public synchronized void run() {
        long filesize = -1L;
        int stat = 0;
        MessageBus.getMessageBus().publishAsync((Object)new DownloadStartEvent());
        this.startInfoFileDownload();
        this.startSubtitleFileDownload();
        try {
            if (!this.cancelDownload()) {
                block14: while (stat < 99) {
                    switch (stat) {
                        case 0: {
                            if (this.starten()) {
                                if (this.datenDownload.isDownloadManager()) {
                                    stat = 10;
                                    break;
                                }
                                stat = 1;
                                break;
                            }
                            stat = 3;
                            break;
                        }
                        case 1: {
                            try {
                                if (this.start.stoppen) {
                                    stat = 10;
                                    if (this.start.process == null) continue block14;
                                    this.start.process.destroy();
                                    break;
                                }
                                if (this.start.process.exitValue() != 0) {
                                    stat = 3;
                                    break;
                                }
                                if (this.start.percent > 990) {
                                    this.start.percent = 1000;
                                }
                                stat = 4;
                            }
                            catch (Exception ex) {
                                try {
                                    this.wait(2000L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            break;
                        }
                        case 3: {
                            if (!this.datenDownload.isRestart()) {
                                stat = 11;
                                break;
                            }
                            if (filesize == -1L) {
                                StarterClass.deleteIfEmpty(this.file.toPath());
                                if (this.file.exists()) {
                                    filesize = this.file.length();
                                    stat = 0;
                                    break;
                                }
                                if (this.start.startcounter < 3) {
                                    stat = 0;
                                    break;
                                }
                                stat = 11;
                                break;
                            }
                            if (!this.file.exists()) {
                                stat = 11;
                                break;
                            }
                            if (this.file.length() > filesize) {
                                filesize = this.file.length();
                                stat = 0;
                                break;
                            }
                            stat = 11;
                            break;
                        }
                        case 4: {
                            if (this.datenDownload.quelle == 1 || this.datenDownload.isDownloadManager()) {
                                stat = 10;
                                break;
                            }
                            if (StarterClass.pruefen(Daten.getInstance(), this.datenDownload, this.start)) {
                                stat = 10;
                                break;
                            }
                            stat = 11;
                            break;
                        }
                        case 11: {
                            this.start.status = (byte)4;
                            stat = 99;
                            break;
                        }
                        case 10: {
                            this.start.status = (byte)3;
                            stat = 99;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("run()", (Throwable)ex);
            SwingUtilities.invokeLater(() -> new MeldungDownloadfehler((Frame)MediathekGui.ui(), ex.getLocalizedMessage(), this.datenDownload).setVisible(true));
        }
        StarterClass.finalizeDownload(this.datenDownload, this.start, this.state);
        this.waitForPendingDownloads();
        MessageBus.getMessageBus().publish((Object)new DownloadFinishedEvent());
    }

    private void startInfoFileDownload() {
        boolean downloadInfoFile = Boolean.parseBoolean(this.datenDownload.arr[35]);
        if (downloadInfoFile) {
            logger.trace("Starting info file download");
            this.infoFuture = CompletableFuture.runAsync(() -> {
                try {
                    MVInfoFile infoFile = new MVInfoFile();
                    infoFile.writeInfoFile(this.datenDownload);
                }
                catch (IOException ex) {
                    logger.error("Failed to write info file", (Throwable)ex);
                }
            });
        }
    }

    private void startSubtitleFileDownload() {
        if (Boolean.parseBoolean(this.datenDownload.arr[37])) {
            logger.trace("Starting subtitle file download");
            this.subtitleFuture = CompletableFuture.runAsync(() -> {
                MVSubtitle subtitleFile = new MVSubtitle();
                subtitleFile.writeSubtitle(this.datenDownload);
            });
        }
    }

    private void waitForPendingDownloads() {
        try {
            if (this.infoFuture != null) {
                this.infoFuture.get();
            }
            if (this.subtitleFuture != null) {
                this.subtitleFuture.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("waitForPendingDownloads().", (Throwable)e);
        }
    }

    private boolean starten() {
        boolean ret = false;
        ++this.start.startcounter;
        StarterClass.startmeldung(this.datenDownload, this.start);
        RuntimeExec runtimeExec = new RuntimeExec(this.datenDownload.mVFilmSize, this.datenDownload.start, this.datenDownload.arr[26], this.datenDownload.arr[27]);
        this.start.process = runtimeExec.exec(true);
        if (this.start.process != null) {
            ret = true;
        }
        return ret;
    }

    private boolean cancelDownload() {
        if (this.datenDownload.isDownloadManager()) {
            return false;
        }
        if (!this.file.exists()) {
            return false;
        }
        this.dialogAbbrechenIsVis = true;
        this.retAbbrechen = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.retAbbrechen = this.abbrechen_();
        } else {
            SwingUtilities.invokeLater(() -> {
                this.retAbbrechen = this.abbrechen_();
                this.dialogAbbrechenIsVis = false;
            });
        }
        while (this.dialogAbbrechenIsVis) {
            try {
                this.wait(100L);
            }
            catch (Exception exception) {}
        }
        return this.retAbbrechen;
    }

    private boolean abbrechen_() {
        boolean result = false;
        if (this.file.exists()) {
            DialogContinueDownload dialogContinueDownload = new DialogContinueDownload(MediathekGui.ui(), this.datenDownload, false);
            dialogContinueDownload.setVisible(true);
            switch (dialogContinueDownload.getResult()) {
                case CANCELLED: {
                    this.state = HttpDownloadState.CANCEL;
                    result = true;
                    break;
                }
                case CONTINUE: {
                    try {
                        Files.deleteIfExists(this.file.toPath());
                        this.file = new File(this.datenDownload.arr[31]);
                    }
                    catch (Exception ex) {
                        logger.error("File exists: {}", (Object)this.datenDownload.arr[31], (Object)ex);
                    }
                    break;
                }
                case RESTART_WITH_NEW_NAME: {
                    if (!dialogContinueDownload.isNewName()) break;
                    this.datenDownload.aufrufBauen();
                    MessageBus.getMessageBus().publishAsync((Object)new DownloadListChangedEvent());
                    try {
                        Files.createDirectories(Paths.get(this.datenDownload.arr[30], new String[0]), new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.file = new File(this.datenDownload.arr[31]);
                }
            }
        }
        return result;
    }
}

