/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.sprite;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Objects;
import net.atmp.PixelImage;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.emoji.SvgNanoParser;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.utils.Log;

public class SpriteImage
implements Sprite {
    private final UImage img;

    public SpriteImage(BufferedImage img) {
        this.img = new UImage(new PixelImage(Objects.requireNonNull(img), AffineTransformType.TYPE_BILINEAR));
    }

    @Override
    public TextBlock asTextBlock(final HColor fontColor, final HColor forcedColor, final double scale, HColor backColor) {
        return new AbstractTextBlock(this){
            final /* synthetic */ SpriteImage this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void drawU(UGraphic ug) {
                HColor usedColor;
                ColorMapper colorMapper = ug.getColorMapper();
                HColor hColor = usedColor = forcedColor == null ? fontColor : forcedColor;
                if (colorMapper == ColorMapper.MONOCHROME) {
                    ug.draw(this.this$0.img.monochrome().scale(scale));
                } else if (usedColor == null) {
                    ug.draw(this.this$0.img.scale(scale));
                } else {
                    ug.draw(this.this$0.img.muteColor(usedColor.toColor(colorMapper)).scale(scale));
                }
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D((double)this.this$0.img.getWidth() * scale, (double)this.this$0.img.getHeight() * scale);
            }
        };
    }

    public static Sprite fromInternal(String name) {
        if (name.endsWith(".png") || name.endsWith(".svg")) {
            throw new IllegalArgumentException();
        }
        try {
            InputStream is = SpriteImage.getInternalSprite(name + ".svg");
            if (is != null) {
                return new SvgNanoParser(FileUtils.readAllBytes(is));
            }
            is = SpriteImage.getInternalSprite(name + ".png");
            if (is != null) {
                return new SpriteImage(SImageIO.read(is));
            }
            return null;
        }
        catch (Throwable e) {
            Logme.error(e);
            return null;
        }
    }

    public static InputStream getInternalSprite(String inner) {
        String path = "/sprites/" + inner;
        Log.info(() -> "Triying " + path);
        InputStream is = SpriteImage.class.getResourceAsStream(path);
        return is;
    }
}

