/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.plugin.EnumDataTypeInfo;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import us.fatehi.utility.string.StringFormat;

final class TableExtRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableExtRetriever.class.getName());

    TableExtRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveAdditionalColumnAttributes() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES)) {
            LOGGER.log(Level.INFO, "Not retrieving additional column attributes, since this was not requested");
            LOGGER.log(Level.FINE, "Additional column attributes SQL statement was not provided");
            return;
        }
        String name = "columns with attibutes";
        RetrievalCounts retrievalCounts = new RetrievalCounts("columns with attibutes");
        Query columnAttributesSql = informationSchemaViews.getQuery(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES);
        try (Connection connection = this.getRetrieverConnection().getConnection("columns with attibutes");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(columnAttributesSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                String columnName = results.getString("COLUMN_NAME");
                LOGGER.log(Level.FINER, "Retrieving additional column attributes: " + columnName);
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
                    continue;
                }
                MutableTable table = tableOptional.get();
                Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
                if (!columnOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find column <%s.%s.%s.%s>", new Object[]{catalogName, schemaName, tableName, columnName}));
                    continue;
                }
                MutableColumn column = columnOptional.get();
                column.addAttributes(results.getAttributes());
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional column attributes", e);
        }
        retrievalCounts.log();
    }

    void retrieveAdditionalColumnMetadata() {
        String name = "columns with additional metadata";
        RetrievalCounts retrievalCounts = new RetrievalCounts("columns with additional metadata");
        try (Connection connection = this.getRetrieverConnection().getConnection("columns with additional metadata");){
            EnumDataTypeHelper enumDataTypeHelper = this.getRetrieverConnection().getEnumDataTypeHelper();
            NamedObjectList<MutableTable> tables = this.catalog.getAllTables();
            for (MutableTable table : tables) {
                retrievalCounts.count();
                NamedObjectList<MutableColumn> columns = table.getAllColumns();
                for (MutableColumn column : columns) {
                    MutableColumnDataType columnDataType = (MutableColumnDataType)column.getColumnDataType();
                    EnumDataTypeInfo enumDataTypeInfo = enumDataTypeHelper.getEnumDataTypeInfo(column, columnDataType, connection);
                    switch (enumDataTypeInfo.getType()) {
                        case enumerated_column: {
                            MutableColumnDataType copiedColumnDataType;
                            columnDataType = copiedColumnDataType = new MutableColumnDataType(columnDataType);
                            columnDataType.setEnumValues(enumDataTypeInfo.getEnumValues());
                            retrievalCounts.countIncluded();
                            break;
                        }
                        case enumerated_data_type: {
                            columnDataType.setEnumValues(enumDataTypeInfo.getEnumValues());
                            retrievalCounts.countIncluded();
                            break;
                        }
                    }
                    column.setColumnDataType(columnDataType);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional column metadata", e);
        }
        retrievalCounts.log();
    }

    void retrieveAdditionalTableAttributes() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES)) {
            LOGGER.log(Level.INFO, "Not retrieving additional table attributes, since this was not requested");
            LOGGER.log(Level.FINE, "Additional table attributes SQL statement was not provided");
            return;
        }
        String name = "tables with attributes";
        RetrievalCounts retrievalCounts = new RetrievalCounts("tables with attributes");
        Query tableAttributesSql = informationSchemaViews.getQuery(InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES);
        try (Connection connection = this.getRetrieverConnection().getConnection("tables with attributes");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableAttributesSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                LOGGER.log(Level.FINER, "Retrieving additional table attributes: " + tableName);
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
                    continue;
                }
                MutableTable table = tableOptional.get();
                table.addAttributes(results.getAttributes());
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional table attributes", e);
        }
        retrievalCounts.log();
    }

    void retrieveTableDefinitions() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.EXT_TABLES)) {
            LOGGER.log(Level.INFO, "Not retrieving table definitions, since this was not requested");
            LOGGER.log(Level.FINE, "Table definitions SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving table definitions");
        String name = "table definitions";
        RetrievalCounts retrievalCounts = new RetrievalCounts("table definitions");
        Query tableDefinitionsInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.EXT_TABLES);
        try (Connection connection = this.getRetrieverConnection().getConnection("table definitions");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableDefinitionsInformationSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
                    continue;
                }
                MutableTable table = tableOptional.get();
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving table information <%s>", new Object[]{tableName}));
                String definition = results.getString("TABLE_DEFINITION");
                table.appendDefinition(definition);
                table.addAttributes(results.getAttributes());
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table definitions", e);
        }
        retrievalCounts.log();
    }
}

