/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.retrying;

import java.io.Serializable;
import java.time.Duration;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.core.ObsoleteApi;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.AutoValue_RetrySettings;
import net.snowflake.client.jdbc.internal.google.api.gax.util.TimeConversionUtils;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;

@AutoValue
public abstract class RetrySettings
implements Serializable {
    private static final long serialVersionUID = 8258475264439710899L;

    @ObsoleteApi(value="Use getTotalTimeoutDuration() instead")
    public net.snowflake.client.jdbc.internal.threeten.bp.Duration getTotalTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getTotalTimeoutDuration());
    }

    public abstract Duration getTotalTimeoutDuration();

    @ObsoleteApi(value="Use getInitialRetryDelayDuration() instead")
    public net.snowflake.client.jdbc.internal.threeten.bp.Duration getInitialRetryDelay() {
        return TimeConversionUtils.toThreetenDuration(this.getInitialRetryDelayDuration());
    }

    public abstract Duration getInitialRetryDelayDuration();

    public abstract double getRetryDelayMultiplier();

    @ObsoleteApi(value="Use getMaxRetryDelayDuration()")
    public net.snowflake.client.jdbc.internal.threeten.bp.Duration getMaxRetryDelay() {
        return TimeConversionUtils.toThreetenDuration(this.getMaxRetryDelayDuration());
    }

    public abstract Duration getMaxRetryDelayDuration();

    public abstract int getMaxAttempts();

    @Deprecated
    @VisibleForTesting
    public abstract boolean isJittered();

    @ObsoleteApi(value="Use getInitialRpcTimeoutDuration() instead")
    public final net.snowflake.client.jdbc.internal.threeten.bp.Duration getInitialRpcTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getInitialRpcTimeoutDuration());
    }

    public abstract Duration getInitialRpcTimeoutDuration();

    public abstract double getRpcTimeoutMultiplier();

    @ObsoleteApi(value="Use getMaxRpcTimeoutDuration() instead")
    public final net.snowflake.client.jdbc.internal.threeten.bp.Duration getMaxRpcTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getMaxRpcTimeoutDuration());
    }

    public abstract Duration getMaxRpcTimeoutDuration();

    public static Builder newBuilder() {
        return new AutoValue_RetrySettings.Builder().setTotalTimeoutDuration(Duration.ZERO).setInitialRetryDelayDuration(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelayDuration(Duration.ZERO).setMaxAttempts(0).setJittered(true).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @ObsoleteApi(value="Use setTotalTimeoutDuration(java.time.Duration) instead")
        public final Builder setTotalTimeout(net.snowflake.client.jdbc.internal.threeten.bp.Duration totalTimeout) {
            return this.setTotalTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(totalTimeout));
        }

        public abstract Builder setTotalTimeoutDuration(Duration var1);

        @ObsoleteApi(value="Use setInitialRetryDelayDuration(java.time.Duration) instead")
        public final Builder setInitialRetryDelay(net.snowflake.client.jdbc.internal.threeten.bp.Duration initialDelay) {
            return this.setInitialRetryDelayDuration(TimeConversionUtils.toJavaTimeDuration(initialDelay));
        }

        public abstract Builder setInitialRetryDelayDuration(Duration var1);

        public abstract Builder setRetryDelayMultiplier(double var1);

        @ObsoleteApi(value="Use setMaxRetryDelayDuration(java.time.Duration) instead")
        public final Builder setMaxRetryDelay(net.snowflake.client.jdbc.internal.threeten.bp.Duration maxDelay) {
            return this.setMaxRetryDelayDuration(TimeConversionUtils.toJavaTimeDuration(maxDelay));
        }

        public abstract Builder setMaxRetryDelayDuration(Duration var1);

        public abstract Builder setMaxAttempts(int var1);

        @Deprecated
        @VisibleForTesting
        public abstract Builder setJittered(boolean var1);

        @ObsoleteApi(value="Use setInitialRpcTimeoutDuration(java.time.Duration) instead")
        public final Builder setInitialRpcTimeout(net.snowflake.client.jdbc.internal.threeten.bp.Duration initialTimeout) {
            return this.setInitialRpcTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(initialTimeout));
        }

        public abstract Builder setInitialRpcTimeoutDuration(Duration var1);

        public abstract Builder setRpcTimeoutMultiplier(double var1);

        @ObsoleteApi(value="Use setMaxRpcTimeoutDuration(java.time.Duration) instead")
        public final Builder setMaxRpcTimeout(net.snowflake.client.jdbc.internal.threeten.bp.Duration maxTimeout) {
            return this.setMaxRpcTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(maxTimeout));
        }

        public abstract Builder setMaxRpcTimeoutDuration(Duration var1);

        @ObsoleteApi(value="Use getTotalTimeoutDuration() instead")
        public final net.snowflake.client.jdbc.internal.threeten.bp.Duration getTotalTimeout() {
            return TimeConversionUtils.toThreetenDuration(this.getTotalTimeoutDuration());
        }

        public abstract Duration getTotalTimeoutDuration();

        @ObsoleteApi(value="Use getInitialRetryDelayDuration() instead")
        public final net.snowflake.client.jdbc.internal.threeten.bp.Duration getInitialRetryDelay() {
            return TimeConversionUtils.toThreetenDuration(this.getInitialRetryDelayDuration());
        }

        public abstract Duration getInitialRetryDelayDuration();

        public abstract double getRetryDelayMultiplier();

        public abstract int getMaxAttempts();

        public abstract boolean isJittered();

        @ObsoleteApi(value="Use getMaxRetryDelayDuration() instead")
        public final net.snowflake.client.jdbc.internal.threeten.bp.Duration getMaxRetryDelay() {
            return TimeConversionUtils.toThreetenDuration(this.getMaxRetryDelayDuration());
        }

        public abstract Duration getMaxRetryDelayDuration();

        @ObsoleteApi(value="Use getInitialRpcTimeoutDuration() instead")
        public final net.snowflake.client.jdbc.internal.threeten.bp.Duration getInitialRpcTimeout() {
            return TimeConversionUtils.toThreetenDuration(this.getInitialRpcTimeoutDuration());
        }

        public abstract Duration getInitialRpcTimeoutDuration();

        public abstract double getRpcTimeoutMultiplier();

        @ObsoleteApi(value="Use getMaxRpcTimeoutDuration() instead")
        public final net.snowflake.client.jdbc.internal.threeten.bp.Duration getMaxRpcTimeout() {
            return TimeConversionUtils.toThreetenDuration(this.getMaxRpcTimeoutDuration());
        }

        public abstract Duration getMaxRpcTimeoutDuration();

        @BetaApi
        @ObsoleteApi(value="Use setLogicalTimeout(java.time.Duration) instead")
        public Builder setLogicalTimeout(net.snowflake.client.jdbc.internal.threeten.bp.Duration timeout) {
            return this.setLogicalTimeout(TimeConversionUtils.toJavaTimeDuration(timeout));
        }

        @BetaApi
        public Builder setLogicalTimeout(Duration timeout) {
            return this.setRpcTimeoutMultiplier(1.0).setInitialRpcTimeoutDuration(timeout).setMaxRpcTimeoutDuration(timeout).setTotalTimeoutDuration(timeout);
        }

        abstract RetrySettings autoBuild();

        public RetrySettings build() {
            RetrySettings params = this.autoBuild();
            if (params.getTotalTimeoutDuration().toMillis() < 0L) {
                throw new IllegalStateException("total timeout must not be negative");
            }
            if (params.getInitialRetryDelayDuration().toMillis() < 0L) {
                throw new IllegalStateException("initial retry delay must not be negative");
            }
            if (params.getRetryDelayMultiplier() < 1.0) {
                throw new IllegalStateException("retry delay multiplier must be at least 1");
            }
            if (params.getMaxRetryDelayDuration().compareTo(params.getInitialRetryDelayDuration()) < 0) {
                throw new IllegalStateException("max retry delay must not be shorter than initial delay");
            }
            if (params.getMaxAttempts() < 0) {
                throw new IllegalStateException("max attempts must be non-negative");
            }
            if (params.getInitialRpcTimeoutDuration().toMillis() < 0L) {
                throw new IllegalStateException("initial rpc timeout must not be negative");
            }
            if (params.getMaxRpcTimeoutDuration().compareTo(params.getInitialRpcTimeoutDuration()) < 0) {
                throw new IllegalStateException("max rpc timeout must not be shorter than initial timeout");
            }
            if (params.getRpcTimeoutMultiplier() < 1.0) {
                throw new IllegalStateException("rpc timeout multiplier must be at least 1");
            }
            return params;
        }

        public Builder merge(Builder newSettings) {
            if (newSettings.getTotalTimeoutDuration() != null) {
                this.setTotalTimeoutDuration(newSettings.getTotalTimeoutDuration());
            }
            if (newSettings.getInitialRetryDelayDuration() != null) {
                this.setInitialRetryDelayDuration(newSettings.getInitialRetryDelayDuration());
            }
            if (newSettings.getRetryDelayMultiplier() >= 1.0) {
                this.setRetryDelayMultiplier(newSettings.getRetryDelayMultiplier());
            }
            if (newSettings.getMaxRetryDelayDuration() != null) {
                this.setMaxRetryDelayDuration(newSettings.getMaxRetryDelayDuration());
            }
            this.setMaxAttempts(newSettings.getMaxAttempts());
            this.setJittered(newSettings.isJittered());
            if (newSettings.getInitialRpcTimeoutDuration() != null) {
                this.setInitialRpcTimeoutDuration(newSettings.getInitialRpcTimeoutDuration());
            }
            if (newSettings.getRpcTimeoutMultiplier() >= 1.0) {
                this.setRpcTimeoutMultiplier(newSettings.getRpcTimeoutMultiplier());
            }
            if (newSettings.getMaxRpcTimeoutDuration() != null) {
                this.setMaxRpcTimeoutDuration(newSettings.getMaxRpcTimeoutDuration());
            }
            return this;
        }
    }
}

