/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage;

import net.snowflake.client.jdbc.internal.microsoft.azure.storage.LocationMode;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.RetryContext;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageLocation;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;

public class RetryInfo {
    private StorageLocation targetLocation;
    private LocationMode updatedLocationMode;
    private int retryInterval = 3000;

    public RetryInfo() {
        this.targetLocation = StorageLocation.PRIMARY;
        this.updatedLocationMode = LocationMode.PRIMARY_ONLY;
    }

    public RetryInfo(RetryContext retryContext) {
        Utility.assertNotNull("retryContext", retryContext);
        this.targetLocation = retryContext.getNextLocation();
        this.updatedLocationMode = retryContext.getLocationMode();
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public final StorageLocation getTargetLocation() {
        return this.targetLocation;
    }

    public LocationMode getUpdatedLocationMode() {
        return this.updatedLocationMode;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval > 0 ? retryInterval : 0;
    }

    public void setTargetLocation(StorageLocation targetLocation) {
        this.targetLocation = targetLocation;
    }

    public void setUpdatedLocationMode(LocationMode updatedLocationMode) {
        this.updatedLocationMode = updatedLocationMode;
    }

    public String toString() {
        return String.format(Utility.LOCALE_US, "(%s,%s)", new Object[]{this.targetLocation, this.retryInterval});
    }
}

