/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import schemacrawler.inclusionrule.ExcludeAll;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.InclusionRuleWithRegularExpression;
import schemacrawler.inclusionrule.RegularExpressionInclusionRule;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.utility.EnumUtility;
import us.fatehi.utility.Utility;

public final class LimitOptionsBuilder
implements OptionsBuilder<LimitOptionsBuilder, LimitOptions> {
    private final Map<DatabaseObjectRuleForInclusion, InclusionRule> inclusionRules = new EnumMap<DatabaseObjectRuleForInclusion, InclusionRule>(DatabaseObjectRuleForInclusion.class);
    private String tableNamePattern;
    private TableTypes tableTypes;
    private EnumSet<RoutineType> routineTypes;

    public static LimitOptionsBuilder builder() {
        return new LimitOptionsBuilder();
    }

    public static LimitOptions newLimitOptions() {
        return LimitOptionsBuilder.builder().toOptions();
    }

    private static EnumSet<RoutineType> defaultRoutineTypes() {
        return EnumSet.of(RoutineType.function, RoutineType.procedure);
    }

    private static TableTypes defaultTableTypes() {
        return TableTypes.from("BASE TABLE", "TABLE", "VIEW");
    }

    private LimitOptionsBuilder() {
        for (DatabaseObjectRuleForInclusion ruleForInclusion : DatabaseObjectRuleForInclusion.values()) {
            this.resetToDefault(ruleForInclusion);
        }
        this.tableTypes = LimitOptionsBuilder.defaultTableTypes();
        this.routineTypes = LimitOptionsBuilder.defaultRoutineTypes();
    }

    public LimitOptionsBuilder fromOptions(LimitOptions options) {
        if (options == null) {
            return this;
        }
        for (DatabaseObjectRuleForInclusion ruleForInclusion : DatabaseObjectRuleForInclusion.values()) {
            this.inclusionRules.put(ruleForInclusion, options.get(ruleForInclusion));
        }
        this.tableTypes = options.getTableTypes();
        this.tableNamePattern = options.getTableNamePattern();
        this.routineTypes = EnumSet.copyOf(options.getRoutineTypes());
        return this;
    }

    public LimitOptionsBuilder include(DatabaseObjectRuleForInclusion ruleForInclusion, InclusionRule inclusionRule) {
        if (inclusionRule == null) {
            this.resetToDefault(ruleForInclusion);
        } else {
            this.inclusionRules.put(ruleForInclusion, inclusionRule);
        }
        return this;
    }

    public LimitOptionsBuilder includeAllRoutines() {
        this.includeRoutines(new IncludeAll());
        return this;
    }

    public LimitOptionsBuilder includeAllSequences() {
        this.includeSequences(new IncludeAll());
        return this;
    }

    public LimitOptionsBuilder includeAllSynonyms() {
        this.includeSynonyms(new IncludeAll());
        return this;
    }

    public LimitOptionsBuilder includeAllTables() {
        this.includeTables(new IncludeAll());
        return this;
    }

    public LimitOptionsBuilder includeColumns(InclusionRule columnInclusionRule) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForColumnInclusion, columnInclusionRule);
    }

    public LimitOptionsBuilder includeColumns(Pattern columnPattern) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForColumnInclusion, columnPattern);
    }

    public LimitOptionsBuilder includeRoutineParameters(InclusionRule routineParameterInclusionRule) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion, routineParameterInclusionRule);
    }

    public LimitOptionsBuilder includeRoutineParameters(Pattern routineParameterPattern) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion, routineParameterPattern);
    }

    public LimitOptionsBuilder includeRoutines(InclusionRule routineInclusionRule) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion, routineInclusionRule);
    }

    public LimitOptionsBuilder includeRoutines(Pattern routinePattern) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion, routinePattern);
    }

    public LimitOptionsBuilder includeSchemas(InclusionRule schemaInclusionRule) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion, schemaInclusionRule);
    }

    public LimitOptionsBuilder includeSchemas(Pattern schemaPattern) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion, schemaPattern);
    }

    public LimitOptionsBuilder includeSequences(InclusionRule sequenceInclusionRule) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForSequenceInclusion, sequenceInclusionRule);
    }

    public LimitOptionsBuilder includeSequences(Pattern sequencePattern) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForSequenceInclusion, sequencePattern);
    }

    public LimitOptionsBuilder includeSynonyms(InclusionRule synonymInclusionRule) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForSynonymInclusion, synonymInclusionRule);
    }

    public LimitOptionsBuilder includeSynonyms(Pattern synonymPattern) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForSynonymInclusion, synonymPattern);
    }

    public LimitOptionsBuilder includeTables(InclusionRule tableInclusionRule) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForTableInclusion, tableInclusionRule);
    }

    public LimitOptionsBuilder includeTables(Pattern tablePattern) {
        return this.include(DatabaseObjectRuleForInclusion.ruleForTableInclusion, tablePattern);
    }

    public LimitOptionsBuilder routineTypes(Collection<RoutineType> routineTypes) {
        this.routineTypes = routineTypes == null ? LimitOptionsBuilder.defaultRoutineTypes() : (routineTypes.isEmpty() ? EnumSet.noneOf(RoutineType.class) : EnumSet.copyOf(routineTypes));
        return this;
    }

    public LimitOptionsBuilder routineTypes(String routineTypesString) {
        HashSet<RoutineType> routineTypesCollection;
        if (routineTypesString != null) {
            routineTypesCollection = new HashSet<RoutineType>();
            String[] routineTypeStrings = routineTypesString.split(",");
            if (routineTypeStrings != null && routineTypeStrings.length > 0) {
                for (String routineTypeString : routineTypeStrings) {
                    RoutineType routineType = EnumUtility.enumValue(routineTypeString.toLowerCase(Locale.ENGLISH), RoutineType.unknown);
                    if (routineType == RoutineType.unknown) continue;
                    routineTypesCollection.add(routineType);
                }
            }
        } else {
            routineTypesCollection = null;
        }
        return this.routineTypes(routineTypesCollection);
    }

    public LimitOptionsBuilder tableNamePattern(String tableNamePattern) {
        this.tableNamePattern = Utility.isBlank((CharSequence)tableNamePattern) ? null : tableNamePattern;
        return this;
    }

    public LimitOptionsBuilder tableTypes(Collection<String> tableTypeStrings) {
        this.tableTypes = TableTypes.from(tableTypeStrings);
        return this;
    }

    public LimitOptionsBuilder tableTypes(String ... tableTypeStrings) {
        this.tableTypes = TableTypes.from(tableTypeStrings);
        return this;
    }

    public LimitOptionsBuilder tableTypes(String tableTypesString) {
        this.tableTypes = TableTypes.from(tableTypesString);
        return this;
    }

    @Override
    public LimitOptions toOptions() {
        return new LimitOptions(new EnumMap<DatabaseObjectRuleForInclusion, InclusionRule>(this.inclusionRules), this.tableTypes, this.tableNamePattern, this.routineTypes);
    }

    private InclusionRule getDefaultInclusionRule(DatabaseObjectRuleForInclusion ruleForInclusion) {
        InclusionRuleWithRegularExpression defaultInclusionRule = ruleForInclusion.isExcludeByDefault() ? new ExcludeAll() : new IncludeAll();
        return defaultInclusionRule;
    }

    private LimitOptionsBuilder include(DatabaseObjectRuleForInclusion ruleForInclusion, Pattern pattern) {
        return this.include(ruleForInclusion, new RegularExpressionInclusionRule(pattern));
    }

    private void resetToDefault(DatabaseObjectRuleForInclusion ruleForInclusion) {
        this.inclusionRules.put(ruleForInclusion, this.getDefaultInclusionRule(ruleForInclusion));
    }
}

