/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

public class ByteArrayBuffer {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private byte[] buffer;
    private int count;

    public ByteArrayBuffer() {
        this(32);
    }

    public ByteArrayBuffer(int initialCapacity) {
        this.buffer = new byte[initialCapacity];
        this.count = 0;
    }

    public void append(int value) {
        this.ensureCapacity(this.count + 1);
        this.buffer[this.count] = (byte)value;
        ++this.count;
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ByteArrayBuffer.hugeCapacity(minCapacity);
        }
        this.buffer = ByteArrayBuffer.copyOf(this.buffer, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buffer.length > 0) {
            this.grow(minCapacity);
        }
    }

    public byte[] getInternalBytes() {
        return this.buffer;
    }

    public int getLength() {
        return this.count;
    }

    public byte[] getByteArray() {
        return ByteArrayBuffer.copyOf(this.buffer, this.count);
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

