/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.mysql;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.plugin.EnumDataTypeInfo;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import us.fatehi.utility.Utility;

public class MySQLEnumDataTypeHelper
implements EnumDataTypeHelper {
    private static Pattern enumPattern = Pattern.compile("enum.*\\((.*)\\)", 2);

    private static List<String> getEnumValues(Column column) {
        Objects.requireNonNull(column, "No column provided");
        ArrayList<String> enumValues = new ArrayList<String>();
        String columnTypeString = (String)column.getAttribute("COLUMN_TYPE");
        if (Utility.isBlank((String)columnTypeString)) {
            return enumValues;
        }
        Matcher matcher = enumPattern.matcher(columnTypeString);
        if (!matcher.matches()) {
            return enumValues;
        }
        String group = matcher.group(1);
        if (!Utility.isBlank((String)group)) {
            String[] enumValuesQuoted;
            for (String enumValueQuoted : enumValuesQuoted = group.split(",")) {
                if (Utility.isBlank((String)enumValueQuoted) || enumValueQuoted.length() < 2 || !enumValueQuoted.startsWith("'") || !enumValueQuoted.endsWith("'")) continue;
                String enumValue = enumValueQuoted.substring(1, enumValueQuoted.length() - 1);
                enumValues.add(enumValue);
            }
        }
        return enumValues;
    }

    public EnumDataTypeInfo getEnumDataTypeInfo(Column column, ColumnDataType columnDataType, Connection connection) {
        Objects.requireNonNull(column, "No column provided");
        List<String> enumValues = MySQLEnumDataTypeHelper.getEnumValues(column);
        EnumDataTypeInfo.EnumDataTypeTypes enumType = enumValues.isEmpty() ? EnumDataTypeInfo.EnumDataTypeTypes.not_enumerated : EnumDataTypeInfo.EnumDataTypeTypes.enumerated_column;
        return new EnumDataTypeInfo(enumType, enumValues);
    }
}

