/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.codegen;

import com.ibm.db2.cmx.annotation.Update;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.handlers.CallHandlerWithParameters;
import com.ibm.db2.cmx.runtime.handlers.ParameterHandler;
import com.ibm.db2.cmx.runtime.handlers.ResultHandler;
import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementAttributes;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.binder.BindLexer;
import com.ibm.db2.cmx.tools.internal.generator.DatabaseProcessor;
import com.ibm.db2.cmx.tools.internal.generator.GeneratorImpl;
import com.ibm.db2.cmx.tools.internal.generator.HandlerInfo;
import com.ibm.db2.cmx.tools.internal.generator.codegen.CallHandlerGenerator;
import com.ibm.db2.cmx.tools.internal.generator.codegen.ParameterHandlerGenerator;
import com.ibm.db2.cmx.tools.internal.generator.codegen.ResultHandlerGenerator;
import com.ibm.db2.cmx.tools.internal.generator.codegen.RowHandlerGenerator;
import com.ibm.db2.cmx.tools.internal.generator.jdt.TypeHelper;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MetaDataInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class MethodGenerator {
    private StringBuilder stringBuffer_;
    private StringBuilder commentSB_;
    private ClassInfo classInfo_;
    private RowHandlerGenerator rowHandlerGenerator_;
    private CallHandlerGenerator callHandlerGenerator_;
    private ParameterHandlerGenerator parameterHandlerGenerator_;
    private ResultHandlerGenerator resultHandlerGenerator_;
    private boolean rowHandlerNeeded_;
    private final String indent2_ = "  ";

    public MethodGenerator(ClassInfo classInfo, StringBuilder stringBuilder, GeneratorImpl generatorImpl) {
        this.stringBuffer_ = stringBuilder;
        this.commentSB_ = new StringBuilder();
        this.classInfo_ = classInfo;
        this.rowHandlerGenerator_ = new RowHandlerGenerator(this.classInfo_, this.stringBuffer_, generatorImpl);
        this.resultHandlerGenerator_ = new ResultHandlerGenerator(this.classInfo_, this.stringBuffer_, generatorImpl, "  ", this.commentSB_);
        this.callHandlerGenerator_ = new CallHandlerGenerator(this.classInfo_, this.stringBuffer_);
        this.parameterHandlerGenerator_ = new ParameterHandlerGenerator(this.classInfo_, this.stringBuffer_);
    }

    public void generate(MethodInfo methodInfo) {
        Object object;
        Object object2;
        int n2 = this.stringBuffer_.length();
        this.commentSB_.setLength(0);
        ToolsLogger.getLogger().log(Level.FINEST, "generating implementation with method information: " + methodInfo.toString());
        TypeInfo typeInfo = methodInfo.getReturnType();
        boolean bl2 = this.rowHandlerNeeded_ = SqlStatementType.isSELECTorVALUES(methodInfo.getSqlStatementType()) && typeInfo.getBaseType().getJavaType() != JavaType.JDBCRESULTSET && methodInfo.getRowHandlerType() == MethodInfo.HandlerType.GeneratedHandler && methodInfo.getRowHandlerWithParametersType() != MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation && methodInfo.getRowHandlerWithParametersType() != MethodInfo.HandlerType.HandlerProvidedAsMethodParameter;
        if (this.rowHandlerNeeded_ && methodInfo.isNestedBeanPresent()) {
            this.checkForNestedBean(methodInfo);
        }
        this.generateMethod(methodInfo);
        if (this.rowHandlerNeeded_ && (object2 = this.getExternHandlerForMethod(methodInfo, HandlerInfo.HandlerType.ROW_HANDLER)) != null && (methodInfo.getResultMetaDataInfo() == null || methodInfo.getResultMetaDataInfo().getFieldNames() == null)) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_NOMETADATA_FOR_HANDLER", methodInfo.getMethodNameAndParameterTypesString()), null, 10815);
        }
        this.generateStatementDescriptor(methodInfo);
        object2 = methodInfo.getParameterListWithoutHandlers();
        if (methodInfo.getParameterHandlerType() == MethodInfo.HandlerType.GeneratedHandler) {
            this.parameterHandlerGenerator_.generateParameterHandler(methodInfo);
        }
        if (methodInfo.isNestedBean()) {
            this.resultHandlerGenerator_.fixupJoinPointPropertyNames(methodInfo);
            object = this.getExternHandlerForMethod(methodInfo, HandlerInfo.HandlerType.RESULT_HANDLER);
            if (object != null) {
                this.resultHandlerGenerator_.generateResultHandler(methodInfo, typeInfo, (HandlerInfo)object);
            } else {
                this.resultHandlerGenerator_.generateResultHandler(methodInfo, typeInfo);
            }
        } else {
            if (this.rowHandlerNeeded_) {
                object = this.getExternHandlerForMethod(methodInfo, HandlerInfo.HandlerType.ROW_HANDLER);
                if (object != null) {
                    this.rowHandlerGenerator_.generateRowHandler(methodInfo, typeInfo, (HandlerInfo)object);
                } else {
                    this.rowHandlerGenerator_.generateRowHandler(methodInfo, typeInfo, "", null);
                }
            }
            if (methodInfo.getCallHandlerType() == MethodInfo.HandlerType.GeneratedHandler) {
                this.callHandlerGenerator_.generateCallHandler(methodInfo, typeInfo);
            }
            if (object2 != null && methodInfo.getRowHandlerType() == MethodInfo.HandlerType.GeneratedHandler) {
                this.rowHandlerGenerator_.generateGeneratedKeyRowHandler(methodInfo, (List<TypeInfo>)object2);
            }
        }
        object = "";
        if (this.commentSB_.length() > 0) {
            object = DatabaseProcessor.normalizeString(this.commentSB_, '\t');
        }
        ResultHandlerGenerator.replaceSingleSymbolicInSB(n2, "%HB_DESC%", (String)object, this.stringBuffer_);
    }

    private void generateMethod(MethodInfo methodInfo) {
        ToolsLogger.getLogger().log(Level.FINEST, "generating implementation with method information: " + methodInfo.toString());
        this.generateComments("  ", methodInfo.getAnnotationStrings());
        boolean bl2 = methodInfo.getSqlStatementType() == SqlStatementType.CALL;
        TypeInfo typeInfo = methodInfo.getReturnType();
        boolean bl3 = typeInfo.getJavaType() == JavaType.VOID;
        String string = methodInfo.getModifier();
        if (string == null || "".equals(string)) {
            string = "public";
        }
        String string2 = methodInfo.getMethodTypeParametersString();
        this.stringBuffer_.append("  " + string + " " + string2 + typeInfo.getTypeString() + " " + methodInfo.getMethodName() + " (");
        List<TypeInfo> list = methodInfo.getParameterList();
        int n2 = 0;
        if (list != null) {
            for (TypeInfo object2 : list) {
                if (n2++ != 0) {
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append(object2.getTypeString());
            }
        }
        this.stringBuffer_.append(")\n");
        this.stringBuffer_.append("  {\n    ");
        if (!bl3 && !bl2) {
            this.stringBuffer_.append("return ");
        }
        this.stringBuffer_.append(methodInfo.getCodeToInvokeDataMethod());
        List<TypeInfo> list2 = methodInfo.getParameterListWithoutHandlers();
        if (methodInfo.hasAutoGeneratedKeys() && (methodInfo.getSqlStatementType() == SqlStatementType.UPDATE || methodInfo.getSqlStatementType() == SqlStatementType.INSERT || methodInfo.getSqlStatementType() == SqlStatementType.MERGE)) {
            this.stringBuffer_.append(((TypeInfo)list2.get(0)).getName() + ", ");
        }
        this.stringBuffer_.append(methodInfo.getStatementDescriptorInstanceName());
        this.stringBuffer_.append(this.generateHandlerContainer(methodInfo));
        if (methodInfo.isQueryArray()) {
            TypeInfo typeInfo2 = typeInfo.getBaseType();
            if (typeInfo2.getJavaType() == JavaType.MAP) {
                this.stringBuffer_.append(", Map.class");
            } else {
                this.stringBuffer_.append(", " + typeInfo2.getTypeName() + ".class");
            }
        }
        n2 = 1;
        if (list2 != null) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                TypeInfo typeInfo3 = (TypeInfo)iterator.next();
                if (n2++ != 0) {
                    this.stringBuffer_.append(", ");
                }
                if (this.classInfo_.isGenerateForQOC() && SqlStatementType.isSELECTorVALUES(methodInfo.getSqlStatementType()) && typeInfo3.isArrayType() && typeInfo3.getBaseType().getJavaType() != JavaType.OBJECT) {
                    this.stringBuffer_.append("(Object)");
                }
                this.stringBuffer_.append(typeInfo3.getName());
            }
        }
        this.stringBuffer_.append(");\n");
        this.stringBuffer_.append("  }\n\n");
    }

    private void generateStatementDescriptor(MethodInfo methodInfo) {
        List<String> list = null;
        SqlStatementType sqlStatementType = methodInfo.getSqlStatementType();
        boolean bl2 = false;
        if (methodInfo.getAnnotationType() == Update.class && SqlStatementType.isSELECTorVALUES(methodInfo.getSqlStatementType()) && methodInfo.hasMultiRowParameters()) {
            String string = methodInfo.getParameterList().get(0).getFullyQualifiedName();
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("MULTI_ROW_SELECT_NOT_SUPPORTED", methodInfo.getMethodNameAndParameterTypesString(), string), null, 11728, null, methodInfo);
        }
        if (methodInfo.hasAutoGeneratedKeys() && (sqlStatementType == SqlStatementType.UPDATE || sqlStatementType == SqlStatementType.INSERT || sqlStatementType == SqlStatementType.MERGE)) {
            list = methodInfo.getInputBeanInfo().get(0).getAutoGeneratedKeys();
            if (sqlStatementType == SqlStatementType.INSERT) {
                bl2 = true;
                methodInfo.setCursorHoldability(1);
            }
        }
        this.generateComments("  ", new String[0]);
        this.stringBuffer_.append("  @Metadata ()\n");
        this.stringBuffer_.append("  public static final StatementDescriptor " + methodInfo.getStatementDescriptorInstanceName() + " = createStatementDescriptor (\n");
        this.stringBuffer_.append("    \"" + methodInfo.getMethodNameAndParameterTypesString() + "\",\n");
        String string = methodInfo.getCursorName();
        String string2 = methodInfo.getPositionedCursorName();
        if (string2 != null) {
            this.stringBuffer_.append(BindLexer.getJavaLineBreakQuotedString(methodInfo.getSqlWithPositionedUpdateClause(methodInfo.getEscapedProcessedSql(), string2)) + ",\n");
        } else {
            this.stringBuffer_.append(BindLexer.getJavaLineBreakQuotedString(methodInfo.getEscapedProcessedSql()) + ",\n");
        }
        this.stringBuffer_.append("    new int[] {");
        if (methodInfo.hasMultiRowParameters()) {
            this.stringBuffer_.append("MULTI_ROW_PARAMETERS");
        } else if (methodInfo.getParameterHandlerType() != MethodInfo.HandlerType.NoHandler) {
            this.stringBuffer_.append("SINGLE_ROW_PARAMETERS");
        } else {
            this.stringBuffer_.append("NO_PARAMETERS");
        }
        if (bl2 || SqlStatementType.isSELECTorVALUESorXQUERY(sqlStatementType)) {
            if (methodInfo.isSingleRowQuery()) {
                this.stringBuffer_.append(", SINGLE_ROW_RESULT");
            } else {
                this.stringBuffer_.append(", MULTI_ROW_RESULT");
            }
            this.stringBuffer_.append(", " + StatementAttributes.getReadableConcurrency(methodInfo.getCursorConcurrency()));
            this.stringBuffer_.append(", " + StatementAttributes.getReadableHoldability(methodInfo.getCursorHoldability()));
            this.stringBuffer_.append(", " + StatementAttributes.getReadableType(methodInfo.getCursorType()));
            this.stringBuffer_.append(", " + StatementAttributes.getReadableAllowStaticRowsetCursors(methodInfo.getAllowStaticRowsetCursors()));
        }
        this.stringBuffer_.append("},\n");
        this.stringBuffer_.append("    SqlStatementType." + (Object)((Object)methodInfo.getSqlStatementType()) + ",\n");
        if (list != null) {
            this.stringBuffer_.append("    new String[]{");
            int n2 = list.size();
            for (int i10 = 0; i10 < n2; ++i10) {
                this.stringBuffer_.append("\"" + list.get(i10) + "\"");
                if (i10 + 1 >= n2) continue;
                this.stringBuffer_.append(", ");
            }
            this.stringBuffer_.append("},\n");
        } else if (SqlStatementType.isSELECTorVALUESorXQUERY(sqlStatementType)) {
            MetaDataInfo metaDataInfo = methodInfo.getResultMetaDataInfo();
            if (metaDataInfo != null) {
                this.stringBuffer_.append("    new String[]{");
                int n3 = metaDataInfo.getColumnCount();
                String[] stringArray = metaDataInfo.getFieldNames();
                for (int i11 = 0; i11 < n3; ++i11) {
                    this.stringBuffer_.append("\"" + stringArray[i11] + "\"");
                    if (i11 + 1 >= n3) continue;
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append("},\n");
            } else {
                this.stringBuffer_.append("    null,\n");
            }
        } else {
            this.stringBuffer_.append("    null,\n");
        }
        if (methodInfo.getParameterHandlerType() == MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation || methodInfo.getParameterHandlerType() == MethodInfo.HandlerType.GeneratedHandler || methodInfo.getParameterHandlerType() == MethodInfo.HandlerType.DefaultHandler) {
            this.stringBuffer_.append("    new " + methodInfo.getParameterHandlerClassNameForStatementDescriptor() + " (),\n");
        } else {
            this.stringBuffer_.append("    null,\n");
        }
        this.appendObjectArrayForParameterMetaData(methodInfo);
        if (methodInfo.getResultHandlerType() == MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation || methodInfo.getResultHandlerType() == MethodInfo.HandlerType.NestedBeanHandler) {
            this.stringBuffer_.append("    new " + methodInfo.getResultHandlerClassNameForStatementDescriptor() + " (),\n");
        } else {
            this.stringBuffer_.append("    null,\n");
        }
        if (methodInfo.getRowHandlerWithParametersType() == MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation && !methodInfo.isNestedBean()) {
            this.stringBuffer_.append(this.getRowHandlerForStatementDescriptor(methodInfo) + ",\n");
        } else if (!(methodInfo.getRowHandlerType() != MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation && methodInfo.getRowHandlerType() != MethodInfo.HandlerType.GeneratedHandler && methodInfo.getRowHandlerType() != MethodInfo.HandlerType.DefaultHandler || methodInfo.isNestedBean())) {
            this.stringBuffer_.append(this.getRowHandlerForStatementDescriptor(methodInfo) + ",\n");
        } else {
            this.stringBuffer_.append("    null,\n");
        }
        this.appendObjectArrayForResultSetMetaData(methodInfo);
        if (methodInfo.getCallHandlerType() == MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation || methodInfo.getCallHandlerType() == MethodInfo.HandlerType.GeneratedHandler || methodInfo.getCallHandlerType() == MethodInfo.HandlerType.DefaultHandler) {
            this.stringBuffer_.append("    new " + methodInfo.getCallHandlerClassNameForStatementDescriptor() + " (),\n");
        } else {
            this.stringBuffer_.append("    null,\n");
        }
        this.stringBuffer_.append("    identifier,\n");
        this.stringBuffer_.append("    generationTime,\n");
        this.stringBuffer_.append("    collection,\n");
        this.stringBuffer_.append("    forceSingleBindIsolation,\n");
        if (string != null) {
            this.stringBuffer_.append("    \"" + string + "\",\n");
        } else {
            this.stringBuffer_.append("    null,\n");
        }
        this.stringBuffer_.append("    " + methodInfo.getValue());
        this.stringBuffer_.append(");\n\n");
    }

    private HandlerInfo getExternHandlerForMethod(MethodInfo methodInfo, HandlerInfo.HandlerType handlerType) {
        String string;
        List<HandlerInfo> list = this.classInfo_.getHandlerInfoListToExtern();
        if (list != null && list.size() > 0 && (string = methodInfo.getJavaMethodSignature()) != null) {
            for (HandlerInfo handlerInfo : list) {
                if (!string.equals(handlerInfo.getMethodSignature()) || !handlerType.equals((Object)handlerInfo.getHandlerType())) continue;
                return handlerInfo;
            }
        }
        return null;
    }

    private String getRowHandlerForStatementDescriptor(MethodInfo methodInfo) {
        if (methodInfo.getResultMetaDataInfo() == null && !methodInfo.isRowHandlerProvidedAsAnnotation() && !methodInfo.isRowHandlerProvidedAsAnnotation()) {
            TypeInfo typeInfo = methodInfo.getReturnType().getBaseType();
            JavaType javaType = typeInfo.getJavaType();
            switch (javaType) {
                case MAP: {
                    this.rowHandlerNeeded_ = false;
                    return "    getMapRowHandler()";
                }
                case DERIVEDLIST: 
                case COLLECTION: {
                    this.rowHandlerNeeded_ = true;
                    break;
                }
                default: {
                    TypeInfo typeInfo2;
                    List<TypeInfo> list;
                    this.rowHandlerNeeded_ = false;
                    if (typeInfo.isBeanType() && !typeInfo.isPrimitiveOrWrapper()) {
                        return "    getBeanRowHandler(" + typeInfo.getTypeName() + ".class)";
                    }
                    if (methodInfo.hasAutoGeneratedKeys() && (methodInfo.getSqlStatementType() == SqlStatementType.UPDATE || methodInfo.getSqlStatementType() == SqlStatementType.INSERT || methodInfo.getSqlStatementType() == SqlStatementType.MERGE) && (list = methodInfo.getParameterList()).size() > 0 && (typeInfo2 = list.get(0)).isBeanType()) {
                        return "    getBeanRowHandler(" + typeInfo2.getFullyQualifiedName() + ".class)";
                    }
                    return "    getConstantRowHandler(" + typeInfo.getTypeName() + ".class)";
                }
            }
        }
        return "    new " + methodInfo.getRowHandlerClassNameForStatementDescriptor("") + " ()";
    }

    private void appendObjectArrayForParameterMetaData(MethodInfo methodInfo) {
        MetaDataInfo metaDataInfo = methodInfo.getParameterMetaDataInfo();
        if (metaDataInfo != null) {
            int n2 = metaDataInfo.getColumnCount();
            this.stringBuffer_.append("    new int[][]{");
            this.stringBuffer_.append("{");
            int[] nArray = metaDataInfo.getSqlTypeForStorageInImplOrXml();
            for (int i10 = 0; i10 < n2; ++i10) {
                if (i10 != 0) {
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append(TypeHelper.getJdbcSQLTypeString(nArray[i10]));
            }
            this.stringBuffer_.append("},");
            this.stringBuffer_.append(" {");
            int[] nArray2 = metaDataInfo.getSqlPrecision();
            for (int i11 = 0; i11 < n2; ++i11) {
                if (i11 != 0) {
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append(nArray2[i11]);
            }
            this.stringBuffer_.append("},");
            this.stringBuffer_.append(" {");
            int[] nArray3 = metaDataInfo.getSqlScale();
            for (int i12 = 0; i12 < n2; ++i12) {
                if (i12 != 0) {
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append(nArray3[i12]);
            }
            this.stringBuffer_.append("},");
            this.stringBuffer_.append(" {");
            int[] nArray4 = metaDataInfo.getSqlParmMode();
            for (int i13 = 0; i13 < n2; ++i13) {
                if (i13 != 0) {
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append(nArray4[i13]);
            }
            this.stringBuffer_.append("}");
            this.stringBuffer_.append("},\n");
        } else {
            this.stringBuffer_.append("    null,\n");
        }
    }

    private void appendObjectArrayForResultSetMetaData(MethodInfo methodInfo) {
        MetaDataInfo metaDataInfo = methodInfo.getResultMetaDataInfo();
        if (metaDataInfo != null) {
            this.stringBuffer_.append("    new int[][]{");
            this.stringBuffer_.append(" {");
            int[] nArray = metaDataInfo.getSqlTypeForUseInExecution();
            for (int i10 = 0; i10 < nArray.length; ++i10) {
                if (i10 != 0) {
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append(TypeHelper.getJdbcSQLTypeString(nArray[i10]));
            }
            this.stringBuffer_.append("},");
            this.stringBuffer_.append(" {");
            int[] nArray2 = metaDataInfo.getSqlPrecision();
            for (int i11 = 0; i11 < nArray2.length; ++i11) {
                if (i11 != 0) {
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append(nArray2[i11]);
            }
            this.stringBuffer_.append("},");
            this.stringBuffer_.append(" {");
            int[] nArray3 = metaDataInfo.getSqlScale();
            for (int i12 = 0; i12 < nArray3.length; ++i12) {
                if (i12 != 0) {
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append(nArray3[i12]);
            }
            this.stringBuffer_.append("},");
            this.stringBuffer_.append(" {");
            int[] nArray4 = metaDataInfo.getSqlCcsid();
            for (int i13 = 0; i13 < nArray4.length; ++i13) {
                if (i13 != 0) {
                    this.stringBuffer_.append(", ");
                }
                this.stringBuffer_.append(nArray4[i13]);
            }
            this.stringBuffer_.append("}");
            this.stringBuffer_.append("},\n");
        } else {
            this.stringBuffer_.append("    null,\n");
        }
    }

    private void generateComments(String string, String ... stringArray) {
        this.stringBuffer_.append(string + "/**\n");
        if (null != stringArray) {
            for (String string2 : stringArray) {
                if (null == string2) continue;
                this.stringBuffer_.append(BindLexer.getJavaLineBreakCommentedString(string2, string));
            }
            BindLexer.getJavaLineBreakCommentedString("", string);
        }
        this.stringBuffer_.append(string + " * @generated\n");
        this.stringBuffer_.append(string + " */");
        this.stringBuffer_.append("\n");
    }

    public String generateHandlerContainer(MethodInfo methodInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        TypeInfo typeInfo = methodInfo.getResultHandlerFromParameter();
        TypeInfo typeInfo2 = methodInfo.getRowHandlerFromParameter();
        TypeInfo typeInfo3 = methodInfo.getCallHandlerWithParametersFromParameter();
        TypeInfo typeInfo4 = methodInfo.getParameterHandlerFromParameter();
        if (methodInfo.isHandlerContainerNeeded()) {
            String string;
            stringBuilder.append(", new HandlerContainer" + this.getHandlerContainerParameterizedType(methodInfo) + " ( ");
            boolean bl2 = false;
            if (null != typeInfo) {
                string = typeInfo.getName();
                if (null == string) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_NAME_NOT_FOUND_FOR_TYPEINFO", ResultHandler.class.getCanonicalName()), null, 10557, null, methodInfo);
                }
                stringBuilder.append(string);
                bl2 = true;
            } else if (null != typeInfo2) {
                string = typeInfo2.getName();
                if (null == string) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_NAME_NOT_FOUND_FOR_TYPEINFO", RowHandler.class.getCanonicalName()), null, 10558, null, methodInfo);
                }
                stringBuilder.append(string);
                bl2 = true;
            } else if (null != typeInfo3) {
                string = typeInfo3.getName();
                if (null == string) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_NAME_NOT_FOUND_FOR_TYPEINFO", CallHandlerWithParameters.class.getCanonicalName()), null, 10559, null, methodInfo);
                }
                stringBuilder.append(string);
                bl2 = true;
            }
            if (null != typeInfo4) {
                string = typeInfo4.getName();
                if (null == string) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_NAME_NOT_FOUND_FOR_TYPEINFO", ParameterHandler.class.getCanonicalName()), null, 10560, null, methodInfo);
                }
                if (bl2) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
            stringBuilder.append(" )");
        }
        return stringBuilder.toString();
    }

    private String getHandlerContainerParameterizedType(MethodInfo methodInfo) {
        String string = Object.class.getSimpleName();
        TypeInfo typeInfo = methodInfo.getReturnType();
        StringBuilder stringBuilder = new StringBuilder("<");
        if (methodInfo.isMethodCanUseResultHandler()) {
            stringBuilder.append(JavaType.VOID == typeInfo.getJavaType() || TypeHelper.isPrimitive(typeInfo) ? string : typeInfo.getTypeName());
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append(", ");
        if (methodInfo.isMethodCanUseRowHandler()) {
            TypeInfo typeInfo2 = typeInfo.getBaseType();
            stringBuilder.append(JavaType.VOID == typeInfo2.getJavaType() || TypeHelper.isPrimitive(typeInfo2) ? string : typeInfo2.getTypeName());
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append(", ");
        if (methodInfo.isMethodCanUseCallHandlerWithParameters()) {
            stringBuilder.append(JavaType.VOID == typeInfo.getJavaType() || TypeHelper.isPrimitive(typeInfo) ? string : typeInfo.getTypeName());
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append("> ");
        return stringBuilder.toString();
    }

    private void checkForNestedBean(MethodInfo methodInfo) {
        if (methodInfo.getResultHandlerType() != MethodInfo.HandlerType.DefaultHandler) {
            return;
        }
        if (methodInfo.getResultMetaDataInfo() == null) {
            return;
        }
        String[] stringArray = methodInfo.getResultMetaDataInfo().getFieldNames();
        String[] stringArray2 = methodInfo.getResultMetaDataInfo().getTableNames();
        Set<String> set = methodInfo.getOutputBeanInfoMap().keySet();
        for (String string : set) {
            BeanInformation beanInformation = methodInfo.getOutputBeanInfoMap().get(string);
            BeanPropertyInformation beanPropertyInformation = null;
            for (int i10 = 0; i10 < stringArray.length; ++i10) {
                beanPropertyInformation = beanInformation.getPropertyUsingCaseInSensitiveName(stringArray[i10], stringArray2[i10], false);
                if (beanPropertyInformation == null) continue;
                TypeInfo typeInfo = beanPropertyInformation.getPropertyTypeInfo();
                JavaType javaType = typeInfo.getJavaType();
                if (javaType == JavaType.BEAN) {
                    ToolsLogger.getLogger().log(Level.FINEST, "Method: " + methodInfo.getMethodName() + " returns a Nested Bean, top level bean is: " + string);
                    methodInfo.setNestedBean();
                    return;
                }
                if (javaType != JavaType.LIST || (javaType = typeInfo.getBaseType().getJavaType()) != JavaType.BEAN) continue;
                ToolsLogger.getLogger().log(Level.FINEST, "Method: " + methodInfo.getMethodName() + " returns a Nested Bean, top level bean is: " + string);
                methodInfo.setNestedBean();
                return;
            }
        }
    }
}

