/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.testdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;

public class TestSchemaCreator
implements Runnable {
    private final Connection connection;
    private final String scriptsResource;

    private static void executeScriptLine(String scriptResourceLine, Connection connection) {
        String delimiter;
        String scriptResource;
        Objects.requireNonNull(scriptResourceLine, "No script resource line provided");
        Objects.requireNonNull(connection, "No database connection provided");
        String[] split = scriptResourceLine.split(",");
        if (split.length == 1) {
            scriptResource = scriptResourceLine.trim();
            delimiter = scriptResource.isEmpty() ? "#" : ";";
        } else if (split.length == 2) {
            delimiter = split[0].trim();
            scriptResource = split[1].trim();
        } else {
            throw new RuntimeException("Too many fields in \"%s\"".formatted(scriptResourceLine));
        }
        boolean skip = "#".equals(delimiter);
        if (skip) {
            return;
        }
        try (BufferedReader scriptReader = TestSchemaCreator.newClasspathReader(scriptResource);){
            TestSchemaCreator.executeSqlScript(connection, scriptReader, delimiter);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException("Could not read \"%s\"".formatted(scriptResource), e);
        }
    }

    private static void executeSqlScript(Connection connection, BufferedReader reader, String delimiter) throws IOException, SQLException {
        String[] statements;
        String line;
        StringBuilder scriptBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            scriptBuilder.append(line).append("\n");
        }
        String fixedDelimiter = "@".equals(delimiter) ? "\\R@" : delimiter;
        for (String stmt : statements = scriptBuilder.toString().split(fixedDelimiter)) {
            String sql = stmt.strip();
            if (sql.isBlank()) continue;
            try (Statement statement = connection.createStatement();){
                statement.execute(sql);
            }
        }
    }

    private static BufferedReader newClasspathReader(String classpathResource) {
        if (classpathResource == null || classpathResource.isBlank()) {
            throw new IllegalArgumentException("Classpath resource not provided");
        }
        String resource = classpathResource.startsWith("/") ? classpathResource.substring(1) : classpathResource;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return reader;
    }

    public TestSchemaCreator(Connection connection, String scriptsResource, boolean debug) {
        this.connection = Objects.requireNonNull(connection, "No database connection provided");
        this.scriptsResource = Objects.requireNonNull(scriptsResource, "No script resource provided");
    }

    @Override
    public void run() {
        try (BufferedReader reader = TestSchemaCreator.newClasspathReader(this.scriptsResource);){
            reader.lines().forEach(line -> TestSchemaCreator.executeScriptLine(line, this.connection));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

