/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.lib.PyBytesCheckExactNode;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBytes})
public class BytesBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = BytesBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BytesBuiltinsFactory.getFactories();
    }

    @Builtin(name="__bytes__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class BytesNode
    extends PythonUnaryBuiltinNode {
        BytesNode() {
        }

        @Specialization
        static Object bytes(Object self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PyBytesCheckExactNode check, @Cached BytesNodes.GetBytesStorage getBytesStorage) {
            if (check.execute(inliningTarget, self)) {
                return self;
            }
            return PFactory.createBytes(language, getBytesStorage.execute(inliningTarget, self));
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=false)
    @GenerateNodeFactory
    @GenerateUncached
    static abstract class RichCmpNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        RichCmpNode() {
        }

        @Specialization
        static boolean cmp(PBytes self, PBytes other, RichCmpOp op, @Bind Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.GetInternalByteArrayNode getArray) {
            SequenceStorage selfStorage = self.getSequenceStorage();
            SequenceStorage otherStorage = other.getSequenceStorage();
            return BytesNodes.compareByteArrays(op, getArray.execute(inliningTarget, selfStorage), selfStorage.length(), getArray.execute(inliningTarget, otherStorage), otherStorage.length());
        }

        @Fallback
        static Object cmp(Object self, Object other, RichCmpOp op, @Bind Node inliningTarget, @Cached PyBytesCheckNode check, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached.Exclusive @Cached SequenceStorageNodes.GetInternalByteArrayNode getArray, @Cached PRaiseNode raiseNode) {
            if (check.execute(inliningTarget, self)) {
                if (check.execute(inliningTarget, other)) {
                    SequenceStorage selfStorage = getBytesStorage.execute(inliningTarget, self);
                    SequenceStorage otherStorage = getBytesStorage.execute(inliningTarget, other);
                    return BytesNodes.compareByteArrays(op, getArray.execute(inliningTarget, selfStorage), selfStorage.length(), getArray.execute(inliningTarget, otherStorage), otherStorage.length());
                }
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, op.getPythonName(), "bytes", self);
        }
    }

    @Builtin(name="fromhex", minNumOfPositionalArgs=2, isClassmethod=true, numOfPositionalOnlyArgs=2, parameterNames={"$cls", "string"})
    @ArgumentClinic(name="string", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class FromHexNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization(guards={"isBuiltinBytesType(cls)"})
        static PBytes doBytes(Object cls, TruffleString str, @Cached.Shared(value="hexToBytes") @Cached BytesNodes.HexStringToBytesNode hexStringToBytesNode, @Bind PythonLanguage language) {
            return PFactory.createBytes(language, hexStringToBytesNode.execute(str));
        }

        @Specialization(guards={"!isBuiltinBytesType(cls)"})
        static Object doGeneric(VirtualFrame frame, Object cls, TruffleString str, @Cached CallNode callNode, @Cached.Shared(value="hexToBytes") @Cached BytesNodes.HexStringToBytesNode hexStringToBytesNode, @Bind PythonLanguage language) {
            PBytes bytes = PFactory.createBytes(language, hexStringToBytesNode.execute(str));
            return callNode.execute((Frame)frame, cls, bytes);
        }

        protected static boolean isBuiltinBytesType(Object cls) {
            return cls == PythonBuiltinClassType.PBytes;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.FromHexNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="translate", minNumOfPositionalArgs=2, parameterNames={"self", "table", "delete"})
    @GenerateNodeFactory
    public static abstract class TranslateNode
    extends BytesNodes.BaseTranslateNode {
        @Specialization
        static Object translate(VirtualFrame frame, Object self, Object table, Object delete, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached InlinedConditionProfile isLenTable256Profile, @Cached InlinedBranchProfile hasTable, @Cached InlinedBranchProfile hasDelete, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached PyBytesCheckExactNode checkExactNode, @Cached PRaiseNode raiseNode) {
            BytesNodes.BaseTranslateNode.Result result;
            byte[] bTable = null;
            if (table != PNone.NONE) {
                hasTable.enter(inliningTarget);
                bTable = toBytesNode.execute(frame, table);
                TranslateNode.checkLengthOfTable(inliningTarget, bTable, isLenTable256Profile, raiseNode);
            }
            byte[] bDelete = null;
            if (delete != PNone.NO_VALUE) {
                hasDelete.enter(inliningTarget);
                bDelete = toBytesNode.execute(frame, delete);
            }
            byte[] bSelf = toBytesNode.execute(null, self);
            if (bTable != null && bDelete != null) {
                result = TranslateNode.translateAndDelete(bSelf, bTable, bDelete);
            } else if (bTable != null) {
                result = TranslateNode.translate(bSelf, bTable);
            } else if (bDelete != null) {
                result = TranslateNode.delete(bSelf, bDelete);
            } else {
                if (!checkExactNode.execute(inliningTarget, self)) {
                    return PFactory.createBytes(language, bSelf);
                }
                return self;
            }
            if (result.changed || !checkExactNode.execute(inliningTarget, self)) {
                return PFactory.createBytes(language, result.array);
            }
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        public static TruffleString repr(Object self, @Bind Node inliningTarget, @Cached BytesNodes.BytesReprNode reprNode) {
            return reprNode.execute(inliningTarget, self);
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class BytesSubcript
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        BytesSubcript() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object self, Object idx, @Bind Node inliningTarget, @Cached InlinedConditionProfile validProfile, @Cached PyIndexCheckNode indexCheckNode, @Cached PRaiseNode raiseNode, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.SequenceStorageMpSubscriptNode subscriptNode) {
            if (!validProfile.profile(inliningTarget, SequenceStorageNodes.SequenceStorageMpSubscriptNode.isValidIndex(inliningTarget, idx, indexCheckNode))) {
                throw BytesSubcript.raiseNonIntIndex(inliningTarget, raiseNode, idx);
            }
            return subscriptNode.execute(frame, inliningTarget, getBytesStorage.execute(inliningTarget, self), idx, ErrorMessages.LIST_INDEX_OUT_OF_RANGE, PFactory::createBytes);
        }

        @HostCompilerDirectives.InliningCutoff
        private static PException raiseNonIntIndex(Node inliningTarget, PRaiseNode raiseNode, Object index) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "byte", index);
        }
    }

    @Slot(value=Slot.SlotKind.sq_item, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetitemNode
    extends TpSlotSizeArgFun.SqItemBuiltinNode {
        GetitemNode() {
        }

        @Specialization
        static Object doInt(Object self, int key, @Bind Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.SequenceStorageSqItemNode sqItemNode) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            return sqItemNode.execute(inliningTarget, storage, key, ErrorMessages.BYTES_OUT_OF_BOUNDS);
        }
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    static abstract class HashNode
    extends TpSlotHashFun.HashBuiltinNode {
        HashNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static long hash(VirtualFrame frame, Object self, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="self") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached BytesNodes.HashBufferNode hashBufferNode) {
            Object buffer = acquireLib.acquireReadonly(self, frame, indirectCallData);
            try {
                long l = hashBufferNode.execute(inliningTarget, buffer);
                return l;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="bytes", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        static Object byteDone(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) {
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="bytes", minNumOfPositionalArgs=1, parameterNames={"$self", "source", "encoding", "errors"})
    @ArgumentsClinic(value={@ArgumentClinic(name="encoding", conversionClass=BytesNodes.ExpectStringNode.class, args={"\"bytes()\""}), @ArgumentClinic(name="errors", conversionClass=BytesNodes.ExpectStringNode.class, args={"\"bytes()\""})})
    @GenerateNodeFactory
    public static abstract class BytesNewNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.BytesNewNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"isNoValue(source)"})
        static Object doEmpty(Object cls, PNone source, PNone encoding, PNone errors, @Bind Node inliningTarget, @Cached.Exclusive @Cached CreateBytes createBytes) {
            return createBytes.execute(inliningTarget, cls, PythonUtils.EMPTY_BYTE_ARRAY);
        }

        @Specialization(guards={"!isNoValue(source)"})
        static Object doCallBytes(VirtualFrame frame, Object cls, Object source, PNone encoding, PNone errors, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached InlinedConditionProfile hasBytes, @Cached(value="create(T___BYTES__)") LookupSpecialMethodNode lookupBytes, @Cached CallUnaryMethodNode callBytes, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached PyBytesCheckNode check, @Cached.Exclusive @Cached BytesNodes.BytesInitNode bytesInitNode, @Cached.Exclusive @Cached CreateBytes createBytes, @Cached PRaiseNode raiseNode) {
            Object bytesMethod = lookupBytes.execute((Frame)frame, getClassNode.execute(inliningTarget, source), source);
            if (hasBytes.profile(inliningTarget, bytesMethod != PNone.NO_VALUE)) {
                Object bytes = callBytes.executeObject((Frame)frame, bytesMethod, source);
                if (check.execute(inliningTarget, bytes)) {
                    if (cls == PythonBuiltinClassType.PBytes) {
                        return bytes;
                    }
                    return createBytes.execute(inliningTarget, cls, toBytesNode.execute(frame, bytes));
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.RETURNED_NONBYTES, SpecialMethodNames.T___BYTES__, bytes);
            }
            return createBytes.execute(inliningTarget, cls, bytesInitNode.execute(frame, inliningTarget, source, encoding, errors));
        }

        @Specialization(guards={"isNoValue(source) || (!isNoValue(encoding) || !isNoValue(errors))"})
        static Object dontCallBytes(VirtualFrame frame, Object cls, Object source, Object encoding, Object errors, @Bind Node inliningTarget, @Cached.Exclusive @Cached BytesNodes.BytesInitNode bytesInitNode, @Cached.Exclusive @Cached CreateBytes createBytes) {
            return createBytes.execute(inliningTarget, cls, bytesInitNode.execute(frame, inliningTarget, source, encoding, errors));
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class CreateBytes
        extends PNodeWithContext {
            CreateBytes() {
            }

            abstract Object execute(Node var1, Object var2, byte[] var3);

            @Specialization(guards={"isBuiltinBytes(cls)"})
            static PBytes doBuiltin(Object cls, byte[] bytes, @Bind PythonLanguage language) {
                return PFactory.createBytes(language, bytes);
            }

            @Specialization(guards={"!needsNativeAllocationNode.execute(inliningTarget, cls)"})
            static PBytes doManaged(Node inliningTarget, Object cls, byte[] bytes, @Cached.Shared @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
                return PFactory.createBytes(language, cls, getInstanceShape.execute(cls), bytes);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Specialization(guards={"needsNativeAllocationNode.execute(inliningTarget, cls)"})
            static Object doNative(Node inliningTarget, Object cls, byte[] bytes, @Cached.Shared @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNative, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode toPython, @Cached(inline=false) CExtNodes.PCallCapiFunction call) {
                CArrayWrappers.CByteArrayWrapper wrapper = new CArrayWrappers.CByteArrayWrapper(bytes);
                try {
                    Object object = toPython.execute(call.call(NativeCAPISymbol.FUN_BYTES_SUBTYPE_NEW, toNative.execute(cls), wrapper, bytes.length));
                    return object;
                }
                finally {
                    wrapper.free();
                }
            }

            protected static boolean isBuiltinBytes(Object cls) {
                return cls == PythonBuiltinClassType.PBytes;
            }
        }
    }
}

