/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.frame.ReadBuiltinNode;
import com.oracle.graal.python.nodes.frame.ReadGlobalOrBuiltinNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(value=false)
public abstract class ReadGlobalOrBuiltinNode
extends PNodeWithContext {
    public final Object execute(VirtualFrame frame, TruffleString name) {
        CompilerAsserts.partialEvaluationConstant((Object)name);
        return this.executeWithGlobals(frame, PArguments.getGlobals((Frame)frame), name);
    }

    protected abstract Object executeWithGlobals(VirtualFrame var1, Object var2, TruffleString var3);

    public Object read(Frame frame, Object globals, TruffleString name) {
        CompilerAsserts.partialEvaluationConstant((Object)name);
        return this.executeWithGlobals((VirtualFrame)frame, globals, name);
    }

    @NeverDefault
    public static ReadGlobalOrBuiltinNode create() {
        return ReadGlobalOrBuiltinNodeGen.create();
    }

    public static ReadGlobalOrBuiltinNode getUncached() {
        return ReadGlobalOrBuiltinNodeGen.getUncached();
    }

    @Specialization(guards={"isSingleContext()", "globals == cachedGlobals"}, limit="1")
    protected static Object readGlobalCached(PythonModule globals, TruffleString attributeId, @Bind Node inliningTarget, @Cached.Shared(value="readFromBuiltinsNode") @Cached ReadBuiltinNode readFromBuiltinsNode, @Cached.Exclusive @Cached InlinedBranchProfile wasReadFromModule, @Cached.Shared(value="readFromModule") @Cached ReadAttributeFromObjectNode readFromModuleNode, @Cached(value="globals", weak=true) PythonModule cachedGlobals) {
        Object result = readFromModuleNode.execute(cachedGlobals, attributeId);
        return ReadGlobalOrBuiltinNode.returnGlobalOrBuiltin(result, attributeId, readFromBuiltinsNode, inliningTarget, wasReadFromModule);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"readGlobalCached"})
    protected static Object readGlobal(PythonModule globals, TruffleString attributeId, @Bind Node inliningTarget, @Cached.Shared(value="readFromBuiltinsNode") @Cached ReadBuiltinNode readFromBuiltinsNode, @Cached.Exclusive @Cached InlinedBranchProfile wasReadFromModule, @Cached.Shared(value="readFromModule") @Cached ReadAttributeFromObjectNode readFromModuleNode) {
        Object result = readFromModuleNode.execute(globals, attributeId);
        return ReadGlobalOrBuiltinNode.returnGlobalOrBuiltin(result, attributeId, readFromBuiltinsNode, inliningTarget, wasReadFromModule);
    }

    @Specialization(guards={"isSingleContext()", "globals == cachedGlobals", "isBuiltinDict(cachedGlobals)"}, limit="1", rewriteOn={GlobalsDictStorageChanged.class})
    protected static Object readGlobalBuiltinDictCachedUnchangedStorage(PDict globals, TruffleString attributeId, @Bind Node inliningTarget, @Cached.Shared(value="readFromBuiltinsNode") @Cached ReadBuiltinNode readFromBuiltinsNode, @Cached.Exclusive @Cached InlinedBranchProfile wasReadFromModule, @Cached(value="globals", weak=true) PDict cachedGlobals, @Cached(value="globals.getDictStorage()", weak=true) HashingStorage cachedStorage, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
        if (cachedGlobals.getDictStorage() != cachedStorage) {
            throw GlobalsDictStorageChanged.INSTANCE;
        }
        Object result = getItem.execute(inliningTarget, cachedStorage, attributeId);
        return ReadGlobalOrBuiltinNode.returnGlobalOrBuiltin(result == null ? PNone.NO_VALUE : result, attributeId, readFromBuiltinsNode, inliningTarget, wasReadFromModule);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isSingleContext()", "globals == cachedGlobals", "isBuiltinDict(cachedGlobals)"}, replaces={"readGlobalBuiltinDictCachedUnchangedStorage"}, limit="1")
    protected static Object readGlobalBuiltinDictCached(PDict globals, TruffleString attributeId, @Bind Node inliningTarget, @Cached.Shared(value="readFromBuiltinsNode") @Cached ReadBuiltinNode readFromBuiltinsNode, @Cached.Exclusive @Cached InlinedBranchProfile wasReadFromModule, @Cached(value="globals", weak=true) PDict cachedGlobals, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
        Object result = getItem.execute(inliningTarget, cachedGlobals.getDictStorage(), attributeId);
        return ReadGlobalOrBuiltinNode.returnGlobalOrBuiltin(result == null ? PNone.NO_VALUE : result, attributeId, readFromBuiltinsNode, inliningTarget, wasReadFromModule);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isBuiltinDict(globals)"}, replaces={"readGlobalBuiltinDictCached", "readGlobalBuiltinDictCachedUnchangedStorage"})
    protected static Object readGlobalBuiltinDict(PDict globals, TruffleString attributeId, @Bind Node inliningTarget, @Cached.Shared(value="readFromBuiltinsNode") @Cached ReadBuiltinNode readFromBuiltinsNode, @Cached.Exclusive @Cached InlinedBranchProfile wasReadFromModule, @Bind(value="globals.getDictStorage()") HashingStorage storage, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
        Object result = getItem.execute(inliningTarget, storage, attributeId);
        return ReadGlobalOrBuiltinNode.returnGlobalOrBuiltin(result == null ? PNone.NO_VALUE : result, attributeId, readFromBuiltinsNode, inliningTarget, wasReadFromModule);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected static Object readGlobalDictGeneric(VirtualFrame frame, PDict globals, TruffleString attributeId, @Bind Node inliningTarget, @Cached.Shared(value="readFromBuiltinsNode") @Cached ReadBuiltinNode readFromBuiltinsNode, @Cached.Exclusive @Cached InlinedBranchProfile wasReadFromModule, @Cached PyObjectGetItem getItemNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
        try {
            Object result = getItemNode.execute((Frame)frame, inliningTarget, globals, attributeId);
            return ReadGlobalOrBuiltinNode.returnGlobalOrBuiltin(result, attributeId, readFromBuiltinsNode, inliningTarget, wasReadFromModule);
        }
        catch (PException e) {
            e.expect(inliningTarget, PythonErrorType.KeyError, errorProfile);
            return ReadGlobalOrBuiltinNode.returnGlobalOrBuiltin(PNone.NO_VALUE, attributeId, readFromBuiltinsNode, inliningTarget, wasReadFromModule);
        }
    }

    @Fallback
    protected static Object syserr(VirtualFrame frame, Object dict, TruffleString attributeId) {
        throw PRaiseNode.raiseStatic(null, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
    }

    private static Object returnGlobalOrBuiltin(Object result, TruffleString attributeId, ReadBuiltinNode readFromBuiltinsNode, Node inliningTarget, InlinedBranchProfile wasReadFromModule) {
        if (result != PNone.NO_VALUE) {
            wasReadFromModule.enter(inliningTarget);
            return result;
        }
        return readFromBuiltinsNode.execute(attributeId);
    }

    static final class GlobalsDictStorageChanged
    extends RuntimeException {
        private static final GlobalsDictStorageChanged INSTANCE = new GlobalsDictStorageChanged();
        private static final long serialVersionUID = 2982918866373996561L;

        GlobalsDictStorageChanged() {
            super(null, null);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class Lazy
    extends Node {
        public final ReadGlobalOrBuiltinNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        public abstract ReadGlobalOrBuiltinNode execute(Node var1);

        @Specialization
        static ReadGlobalOrBuiltinNode doIt(@Cached(inline=false) ReadGlobalOrBuiltinNode node) {
            return node;
        }
    }
}

