-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2025, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  NULL AS PROCEDURE_CAT,
  PROCEDURES.OWNER AS PROCEDURE_SCHEM,
  PROCEDURES.OBJECT_NAME AS PROCEDURE_NAME,
  PROCEDURES.OBJECT_NAME AS SPECIFIC_NAME,
  CASE WHEN ARGUMENTS.OBJECT_ID IS NULL
    THEN 1
    ELSE 2
  END AS PROCEDURE_TYPE,
  NULL AS REMARKS
FROM
  ${catalogscope}_PROCEDURES PROCEDURES
  LEFT OUTER JOIN ${catalogscope}_ARGUMENTS ARGUMENTS
    ON PROCEDURES.OBJECT_ID = ARGUMENTS.OBJECT_ID
      AND ARGUMENTS.ARGUMENT_NAME IS NULL
      AND ARGUMENTS.POSITION = 0
  INNER JOIN ${catalogscope}_USERS USERS
    ON PROCEDURES.OWNER = USERS.USERNAME
      AND USERS.ORACLE_MAINTAINED = 'N'
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^OPS\$ORACLE$')
WHERE
  REGEXP_LIKE(PROCEDURES.OWNER, '${schema-inclusion-rule}')
  AND PROCEDURES.OBJECT_TYPE = 'PROCEDURE'
ORDER BY
  PROCEDURE_SCHEM,
  PROCEDURE_NAME
