/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.snapshot;

import java.io.File;
import java.util.Objects;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;

public abstract class Snapshot
extends DataSource {
    public static final String PROPERTY_FILE = "prop_file";
    protected static final String PROPERTY_VIEW_CLOSABLE = "prop_view_closable";
    private File file;
    private final SnapshotCategory category;
    private String snapshotID;

    public Snapshot(File file, SnapshotCategory category) {
        this(file, category, null);
    }

    public Snapshot(File file, SnapshotCategory category, DataSource master) {
        super(master);
        this.file = file;
        this.category = category;
    }

    public final File getFile() {
        return this.file;
    }

    public final SnapshotCategory getCategory() {
        return this.category;
    }

    protected final void setFile(File newFile) {
        if (this.file == null && newFile == null) {
            return;
        }
        File oldFile = this.file;
        this.file = newFile;
        if (oldFile == null) {
            this.snapshotID = null;
        }
        this.getChangeSupport().firePropertyChange(PROPERTY_FILE, oldFile, newFile);
    }

    public void save(File directory) {
        File f = this.getFile();
        if (f != null && f.isFile()) {
            File saveFile = Utils.getUniqueFile(directory, f.getName());
            Utils.copyFile(f, saveFile);
            this.getStorage().saveCustomPropertiesTo(new File(saveFile.getAbsolutePath() + ".properties"));
        }
    }

    public boolean supportsSaveAs() {
        return false;
    }

    public void saveAs() {
        throw new UnsupportedOperationException("Save as not supported");
    }

    public boolean supportsDelete() {
        return true;
    }

    public void delete() {
        DataSourceWindowManager.sharedInstance().closeDataSource(this);
        this.getOwner().getRepository().removeDataSource(this);
    }

    @Override
    protected void remove() {
        final File f = this.getFile();
        if (f != null) {
            Utils.FILE_QUEUE.post(new Runnable(){

                @Override
                public void run() {
                    Utils.delete(f, true);
                }
            });
        }
        this.setFile(null);
        super.remove();
    }

    @Override
    protected Storage createStorage() {
        File f = this.getFile();
        if (f != null) {
            String customPropertiesFileName = f.getName() + ".properties";
            if (f.isDirectory()) {
                return new Storage(f, customPropertiesFileName);
            }
            if (f.isFile()) {
                File directory = f.getParentFile();
                return new Storage(directory, customPropertiesFileName);
            }
        }
        return super.createStorage();
    }

    protected final boolean isInSnapshot() {
        return this.getOwner() instanceof Snapshot;
    }

    protected String computeSnapshotID() {
        File f = this.getFile();
        return f == null ? super.hashCode() + "-no_file" : f.getPath();
    }

    private String getSnapshotID() {
        if (this.snapshotID == null) {
            this.snapshotID = this.computeSnapshotID();
        }
        return this.snapshotID;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Snapshot)) {
            return false;
        }
        return Objects.equals(this.getSnapshotID(), ((Snapshot)o).getSnapshotID());
    }

    public int hashCode() {
        return Objects.hashCode(this.getSnapshotID());
    }
}

