﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/gamelift/GameLift_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace GameLift
{
namespace Model
{
  enum class EventCode
  {
    NOT_SET,
    GENERIC_EVENT,
    FLEET_CREATED,
    FLEET_DELETED,
    FLEET_SCALING_EVENT,
    FLEET_STATE_DOWNLOADING,
    FLEET_STATE_VALIDATING,
    FLEET_STATE_BUILDING,
    FLEET_STATE_ACTIVATING,
    FLEET_STATE_ACTIVE,
    FLEET_STATE_ERROR,
    FLEET_STATE_PENDING,
    FLEET_STATE_CREATING,
    FLEET_STATE_CREATED,
    FLEET_STATE_UPDATING,
    FLEET_INITIALIZATION_FAILED,
    FLEET_BINARY_DOWNLOAD_FAILED,
    FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND,
    FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE,
    FLEET_VALIDATION_TIMED_OUT,
    FLEET_ACTIVATION_FAILED,
    FLEET_ACTIVATION_FAILED_NO_INSTANCES,
    FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED,
    SERVER_PROCESS_INVALID_PATH,
    SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT,
    SERVER_PROCESS_PROCESS_READY_TIMEOUT,
    SERVER_PROCESS_CRASHED,
    SERVER_PROCESS_TERMINATED_UNHEALTHY,
    SERVER_PROCESS_FORCE_TERMINATED,
    SERVER_PROCESS_PROCESS_EXIT_TIMEOUT,
    SERVER_PROCESS_SDK_INITIALIZATION_FAILED,
    SERVER_PROCESS_MISCONFIGURED_CONTAINER_PORT,
    GAME_SESSION_ACTIVATION_TIMEOUT,
    FLEET_CREATION_EXTRACTING_BUILD,
    FLEET_CREATION_RUNNING_INSTALLER,
    FLEET_CREATION_VALIDATING_RUNTIME_CONFIG,
    FLEET_VPC_PEERING_SUCCEEDED,
    FLEET_VPC_PEERING_FAILED,
    FLEET_VPC_PEERING_DELETED,
    INSTANCE_INTERRUPTED,
    INSTANCE_RECYCLED,
    INSTANCE_REPLACED_UNHEALTHY,
    FLEET_CREATION_COMPLETED_INSTALLER,
    FLEET_CREATION_FAILED_INSTALLER,
    COMPUTE_LOG_UPLOAD_FAILED,
    GAME_SERVER_CONTAINER_GROUP_CRASHED,
    PER_INSTANCE_CONTAINER_GROUP_CRASHED,
    GAME_SERVER_CONTAINER_GROUP_REPLACED_UNHEALTHY,
    LOCATION_STATE_PENDING,
    LOCATION_STATE_CREATING,
    LOCATION_STATE_CREATED,
    LOCATION_STATE_ACTIVATING,
    LOCATION_STATE_ACTIVE,
    LOCATION_STATE_UPDATING,
    LOCATION_STATE_ERROR,
    LOCATION_STATE_DELETING,
    LOCATION_STATE_DELETED
  };

namespace EventCodeMapper
{
AWS_GAMELIFT_API EventCode GetEventCodeForName(const Aws::String& name);

AWS_GAMELIFT_API Aws::String GetNameForEventCode(EventCode value);
} // namespace EventCodeMapper
} // namespace Model
} // namespace GameLift
} // namespace Aws
