﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/DashboardBehavior.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace QuickSight
{
namespace Model
{

  /**
   * <p>Adds Q&amp;A capabilities to a dashboard. If no topic is linked, Dashboard
   * Q&amp;A uses the data values that are rendered on the dashboard. End users can
   * use Dashboard Q&amp;A to ask for different slices of the data that they see on
   * the dashboard. If a topic is linked, Topic Q&amp;A is enabled.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DataQAEnabledOption">AWS
   * API Reference</a></p>
   */
  class DataQAEnabledOption
  {
  public:
    AWS_QUICKSIGHT_API DataQAEnabledOption() = default;
    AWS_QUICKSIGHT_API DataQAEnabledOption(Aws::Utils::Json::JsonView jsonValue);
    AWS_QUICKSIGHT_API DataQAEnabledOption& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The status of the Data Q&amp;A option on the dashboard.</p>
     */
    inline DashboardBehavior GetAvailabilityStatus() const { return m_availabilityStatus; }
    inline bool AvailabilityStatusHasBeenSet() const { return m_availabilityStatusHasBeenSet; }
    inline void SetAvailabilityStatus(DashboardBehavior value) { m_availabilityStatusHasBeenSet = true; m_availabilityStatus = value; }
    inline DataQAEnabledOption& WithAvailabilityStatus(DashboardBehavior value) { SetAvailabilityStatus(value); return *this;}
    ///@}
  private:

    DashboardBehavior m_availabilityStatus{DashboardBehavior::NOT_SET};
    bool m_availabilityStatusHasBeenSet = false;
  };

} // namespace Model
} // namespace QuickSight
} // namespace Aws
