﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/socialmessaging/SocialMessaging_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/socialmessaging/model/LinkedWhatsAppBusinessAccountIdMetaData.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SocialMessaging
{
namespace Model
{

  /**
   * <p>Contains the results of WhatsAppSignupCallback.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/WhatsAppSignupCallbackResult">AWS
   * API Reference</a></p>
   */
  class WhatsAppSignupCallbackResult
  {
  public:
    AWS_SOCIALMESSAGING_API WhatsAppSignupCallbackResult() = default;
    AWS_SOCIALMESSAGING_API WhatsAppSignupCallbackResult(Aws::Utils::Json::JsonView jsonValue);
    AWS_SOCIALMESSAGING_API WhatsAppSignupCallbackResult& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SOCIALMESSAGING_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>An Amazon Web Services access token generated by
     * <code>WhatsAppSignupCallback</code> and used by
     * <code>WhatsAppSetupFinalization</code>.</p>
     */
    inline const Aws::String& GetAssociateInProgressToken() const { return m_associateInProgressToken; }
    inline bool AssociateInProgressTokenHasBeenSet() const { return m_associateInProgressTokenHasBeenSet; }
    template<typename AssociateInProgressTokenT = Aws::String>
    void SetAssociateInProgressToken(AssociateInProgressTokenT&& value) { m_associateInProgressTokenHasBeenSet = true; m_associateInProgressToken = std::forward<AssociateInProgressTokenT>(value); }
    template<typename AssociateInProgressTokenT = Aws::String>
    WhatsAppSignupCallbackResult& WithAssociateInProgressToken(AssociateInProgressTokenT&& value) { SetAssociateInProgressToken(std::forward<AssociateInProgressTokenT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A LinkedWhatsAppBusinessAccountIdMetaData object map containing the details
     * of any WhatsAppBusiness accounts that have incomplete setup.</p>
     */
    inline const Aws::Map<Aws::String, LinkedWhatsAppBusinessAccountIdMetaData>& GetLinkedAccountsWithIncompleteSetup() const { return m_linkedAccountsWithIncompleteSetup; }
    inline bool LinkedAccountsWithIncompleteSetupHasBeenSet() const { return m_linkedAccountsWithIncompleteSetupHasBeenSet; }
    template<typename LinkedAccountsWithIncompleteSetupT = Aws::Map<Aws::String, LinkedWhatsAppBusinessAccountIdMetaData>>
    void SetLinkedAccountsWithIncompleteSetup(LinkedAccountsWithIncompleteSetupT&& value) { m_linkedAccountsWithIncompleteSetupHasBeenSet = true; m_linkedAccountsWithIncompleteSetup = std::forward<LinkedAccountsWithIncompleteSetupT>(value); }
    template<typename LinkedAccountsWithIncompleteSetupT = Aws::Map<Aws::String, LinkedWhatsAppBusinessAccountIdMetaData>>
    WhatsAppSignupCallbackResult& WithLinkedAccountsWithIncompleteSetup(LinkedAccountsWithIncompleteSetupT&& value) { SetLinkedAccountsWithIncompleteSetup(std::forward<LinkedAccountsWithIncompleteSetupT>(value)); return *this;}
    template<typename LinkedAccountsWithIncompleteSetupKeyT = Aws::String, typename LinkedAccountsWithIncompleteSetupValueT = LinkedWhatsAppBusinessAccountIdMetaData>
    WhatsAppSignupCallbackResult& AddLinkedAccountsWithIncompleteSetup(LinkedAccountsWithIncompleteSetupKeyT&& key, LinkedAccountsWithIncompleteSetupValueT&& value) {
      m_linkedAccountsWithIncompleteSetupHasBeenSet = true; m_linkedAccountsWithIncompleteSetup.emplace(std::forward<LinkedAccountsWithIncompleteSetupKeyT>(key), std::forward<LinkedAccountsWithIncompleteSetupValueT>(value)); return *this;
    }
    ///@}
  private:

    Aws::String m_associateInProgressToken;
    bool m_associateInProgressTokenHasBeenSet = false;

    Aws::Map<Aws::String, LinkedWhatsAppBusinessAccountIdMetaData> m_linkedAccountsWithIncompleteSetup;
    bool m_linkedAccountsWithIncompleteSetupHasBeenSet = false;
  };

} // namespace Model
} // namespace SocialMessaging
} // namespace Aws
