/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.infinispan.jgroups;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.keycloak.config.CachingOptions;
import org.keycloak.config.Option;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.storage.infinispan.CacheManagerFactory;
import org.keycloak.quarkus.runtime.storage.infinispan.jgroups.JGroupsStackConfigurator;
import org.keycloak.quarkus.runtime.storage.infinispan.jgroups.JGroupsUtil;
import org.keycloak.quarkus.runtime.storage.infinispan.jgroups.impl.FileJGroupsTlsConfigurator;
import org.keycloak.quarkus.runtime.storage.infinispan.jgroups.impl.JGroupsJdbcPingStackConfigurator;
import org.keycloak.quarkus.runtime.storage.infinispan.jgroups.impl.JpaJGroupsTlsConfigurator;

public class JGroupsConfigurator {
    private final ConfigurationBuilderHolder holder;
    private final List<JGroupsStackConfigurator> stackConfiguratorList;

    private JGroupsConfigurator(ConfigurationBuilderHolder holder, List<JGroupsStackConfigurator> stackConfiguratorList) {
        this.holder = holder;
        this.stackConfiguratorList = stackConfiguratorList;
    }

    private static void createJdbcPingConfigurator(ConfigurationBuilderHolder holder, List<JGroupsStackConfigurator> configurator) {
        Attribute<String> stackXmlAttribute = JGroupsUtil.transportStackOf(holder);
        if (stackXmlAttribute.isModified() && !JGroupsConfigurator.isJdbcPingStack((String)stackXmlAttribute.get())) {
            CacheManagerFactory.logger.debugf("Custom stack configured (%s). JDBC_PING discovery disabled.", stackXmlAttribute.get());
            return;
        }
        CacheManagerFactory.logger.debug((Object)"JDBC_PING discovery enabled.");
        if (!stackXmlAttribute.isModified()) {
            JGroupsUtil.transportOf(holder).stack("jdbc-ping");
        }
        configurator.add(JGroupsJdbcPingStackConfigurator.INSTANCE);
    }

    private static boolean isJdbcPingStack(String stackName) {
        return "jdbc-ping".equals(stackName) || "jdbc-ping-udp".equals(stackName);
    }

    private static void createTlsConfigurator(List<JGroupsStackConfigurator> configurator) {
        if (!Configuration.isTrue((Option<Boolean>)CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED)) {
            CacheManagerFactory.logger.debug((Object)"JGroups encryption disabled.");
            return;
        }
        if (Configuration.isBlank(CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE) && Configuration.isBlank(CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE)) {
            CacheManagerFactory.logger.debug((Object)"JGroups encryption enabled. Neither KeyStore and Truststore present, using the certificates from database.");
            configurator.add(JpaJGroupsTlsConfigurator.INSTANCE);
            return;
        }
        CacheManagerFactory.logger.debug((Object)"JGroups encryption enabled. KeyStore or Truststore present.");
        configurator.add(FileJGroupsTlsConfigurator.INSTANCE);
    }

    private static boolean isLocal(ConfigurationBuilderHolder holder) {
        return JGroupsUtil.transportOf(holder) == null;
    }

    public static JGroupsConfigurator create(ConfigurationBuilderHolder holder) {
        if (InfinispanUtils.isRemoteInfinispan() || JGroupsConfigurator.isLocal(holder)) {
            CacheManagerFactory.logger.debug((Object)"Multi Site or local mode. Skipping JGroups configuration.");
            return new JGroupsConfigurator(holder, List.of());
        }
        Configuration.getOptionalKcValue(CachingOptions.CACHE_STACK).ifPresent(arg_0 -> ((TransportConfigurationBuilder)JGroupsUtil.transportOf(holder)).stack(arg_0));
        ArrayList<JGroupsStackConfigurator> configurator = new ArrayList<JGroupsStackConfigurator>(2);
        JGroupsConfigurator.createJdbcPingConfigurator(holder, configurator);
        JGroupsConfigurator.createTlsConfigurator(configurator);
        return new JGroupsConfigurator(holder, List.copyOf(configurator));
    }

    public ConfigurationBuilderHolder holder() {
        return this.holder;
    }

    public boolean requiresKeycloakSession() {
        return this.stackConfiguratorList.stream().anyMatch(JGroupsStackConfigurator::requiresKeycloakSession);
    }

    public boolean isLocal() {
        return JGroupsConfigurator.isLocal(this.holder);
    }

    public void configure(KeycloakSession session) {
        if (InfinispanUtils.isRemoteInfinispan() || this.isLocal()) {
            return;
        }
        this.stackConfiguratorList.forEach(jGroupsStackConfigurator -> jGroupsStackConfigurator.configure(this.holder, session));
        JGroupsUtil.warnDeprecatedStack(this.holder);
    }
}

