/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.module.certificates;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.keycloak.common.util.PemUtils;
import org.keycloak.util.JsonSerialization;

public class JGroupsCertificate {
    @JsonProperty(value="prvKey")
    private String privateKeyPem;
    @JsonProperty(value="pubKey")
    private String publicKeyPem;
    @JsonProperty(value="crt")
    private String certificatePem;
    @JsonProperty(value="alias")
    private String alias;
    @JsonProperty(value="generatedMillis")
    private long generatedMillis;

    public String getCertificatePem() {
        return this.certificatePem;
    }

    public void setCertificatePem(String certificatePem) {
        this.certificatePem = certificatePem;
    }

    public String getPrivateKeyPem() {
        return this.privateKeyPem;
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.privateKeyPem = privateKeyPem;
    }

    public String getPublicKeyPem() {
        return this.publicKeyPem;
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.publicKeyPem = publicKeyPem;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public long getGeneratedMillis() {
        return this.generatedMillis;
    }

    public void setGeneratedMillis(long generatedMillis) {
        this.generatedMillis = generatedMillis;
    }

    @JsonIgnore
    public void setCertificate(X509Certificate certificate) {
        Objects.requireNonNull(certificate);
        this.setCertificatePem(PemUtils.encodeCertificate((Certificate)certificate));
    }

    @JsonIgnore
    public void setKeyPair(KeyPair keyPair) {
        Objects.requireNonNull(keyPair);
        this.setPrivateKeyPem(PemUtils.encodeKey((Key)keyPair.getPrivate()));
        this.setPublicKeyPem(PemUtils.encodeKey((Key)keyPair.getPublic()));
    }

    @JsonIgnore
    public X509Certificate getCertificate() {
        return PemUtils.decodeCertificate((String)this.getCertificatePem());
    }

    @JsonIgnore
    public KeyPair getKeyPair() {
        PrivateKey prv = PemUtils.decodePrivateKey((String)this.getPrivateKeyPem());
        PublicKey pub = PemUtils.decodePublicKey((String)this.getPublicKeyPem());
        return new KeyPair(pub, prv);
    }

    @JsonIgnore
    public PrivateKey getPrivateKey() {
        return PemUtils.decodePrivateKey((String)this.getPrivateKeyPem());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JGroupsCertificate that = (JGroupsCertificate)o;
        return Objects.equals(this.privateKeyPem, that.privateKeyPem) && Objects.equals(this.publicKeyPem, that.publicKeyPem) && Objects.equals(this.certificatePem, that.certificatePem);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.privateKeyPem);
        result = 31 * result + Objects.hashCode(this.publicKeyPem);
        result = 31 * result + Objects.hashCode(this.certificatePem);
        return result;
    }

    public boolean isSameAlias(String jsonCertificate) {
        return Objects.equals(this.alias, JGroupsCertificate.fromJson(jsonCertificate).getAlias());
    }

    public static String toJson(JGroupsCertificate entity) {
        try {
            return JsonSerialization.mapper.writeValueAsString((Object)entity);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Should never happen!", e);
        }
    }

    public static JGroupsCertificate fromJson(String json) {
        try {
            return (JGroupsCertificate)JsonSerialization.mapper.readValue(json, JGroupsCertificate.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Should never happen!", e);
        }
    }
}

