/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain;

import java.io.Serializable;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.spi.DotIdentifierSequence;

public final class NavigableRole
implements DotIdentifierSequence,
Serializable {
    public static final String IDENTIFIER_MAPPER_PROPERTY = "_identifierMapper";
    private final NavigableRole parent;
    private final String localName;
    private final String fullPath;

    public NavigableRole(NavigableRole parent, String localName) {
        this(parent, localName, '.');
    }

    public NavigableRole(NavigableRole parent, String localName, char separator) {
        this.parent = parent;
        this.localName = localName;
        if (IDENTIFIER_MAPPER_PROPERTY.equals(localName)) {
            this.fullPath = parent != null ? parent.getFullPath() : "";
        } else {
            String resolvedParent;
            Object prefix = parent != null ? (StringHelper.isEmpty(resolvedParent = parent.getFullPath()) ? "" : resolvedParent + separator) : "";
            this.fullPath = (String)prefix + localName;
        }
    }

    public NavigableRole(String localName) {
        this(null, localName);
    }

    public NavigableRole() {
        this("");
    }

    @Override
    public NavigableRole append(String name) {
        return new NavigableRole(this, name);
    }

    public NavigableRole appendContainer(String name) {
        return new NavigableRole(this, name, '#');
    }

    @Override
    public NavigableRole getParent() {
        return this.parent;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public String getNavigableName() {
        return this.getLocalName();
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.fullPath + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || NavigableRole.class != o.getClass()) {
            return false;
        }
        NavigableRole that = (NavigableRole)o;
        return this.fullPath.equals(that.fullPath);
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }
}

